This is a propositional planning problem with single-effect **operators and an underlying**
directed-path singly connected causal graph. Clearly, Goal **is reachable (Π is solvable) if and**
only if a satisfying assignment for F **can be found. Thus, plan existence for the propositional**
planning problems with directed-path singly connected causal graphs is np**-complete.** 
Lemma 4 Given k ordered sequences σ1, · · · , σk of n **elements each, the number** T[k] of different merges of σ1, · · · , σk, preserving the orderings induced by σ1, · · · , σk **on their elements, is given by:**

$$T[k]\;=\;\prod_{i=1}^{k-1}\sum_{j=1}^{n}{\binom{n-1}{j-1}}{\binom{n i+1}{j}}$$
$$(6)$$

Proof: Considering the merge operation of such k **sequences as iterative merge of** σi, 2 ≤ i ≤ k, with the already merged sequences σ1, . . . , σi−1, it is easy to see that T(k**) can**
be expressed as:

$$T[k]\;=\;{\begin{cases}T[k-1]\cdot S\left[n(k-1),n\right],&k>1\\ 1,&k=1\end{cases}}$$
$$\left(7\right)$$

where S[x, y] stands for the number of different, order preserving merges of two **ordered** sequences of sizes x and y **(without loss of generality, we assume that** x ≥ y).

We consider the process of merging two ordered sequences σ and σ
′, |σ**| ≥ |**σ
′|**, as:**
(i) partition of σ
′into j **sub-sequences,**
(ii) partition of σ into l sub-sequences, where j − 1 ≤ l ≤ j **+ 1, and**
(iii) interleaving and order preserving concatenation of the sub-sequences of σ and σ
′.

First, observe that σ
′can be partitioned into 1 ≤ j ≤ |σ
′| **sub-sequences. Second, for**
any j, the numbers of different partitions corresponding to steps **(i) and (ii) are** |σ
′
|−1 j−1 and |σ|+1 j, respectively. Finally, given a pair of such partitions of σ and σ
′**, there exist exactly**
one possible interleaving and order preserving concatenation as in step (iii). Therefore, we have:

$$S(x,y)\;=\;\sum_{j=1}^{y}{\binom{y-1}{j-1}}{\binom{x+1}{j}}$$
$$\quad(8)$$. 
$\triangleright$ to Eq. 6. $\Box$
(8)
and combining Eq. 7 with Eq. 8, we arrive to Eq. 6. 