
## 2.1 Causal Graphs

Causal graphs **were used by Williams and Nayak (1997) as a tool for describing the structure** of planning domains with unary operators. They represent a dependence relation between the state variables in the domain. A causal graph G **is a directed graph whose nodes**
correspond to the state variables. An edge from p to q **appears in the causal graph if** and only if some operator that changes the value of q **has a prevail condition involving** some value of p. Hence the immediate predecessors of q in G **are all those variables that** affect our ability to change the value of q**. Such a problem structure was introduced by**
Knoblock (1994) in the context of automatic generation of abstractions for planning. The causal graph is an intuitive model which is easily constructed given any planning problem.

Causal graphs are not the only graphical structure that can be derived from a given planning problem, and effectively exploited in solving it. For instance, graphs in which operators and literals (and not variables/propositions) are represented by the nodes, and the edges represent both prevail and preconditions were introduced by Etzioni (1993) and Smith and Peot (1993). In particular, problem space graphs of Etzioni (1993) and operator graphs of Smith and Peot (1993) were proposed as mechanisms to reduce the number of threats that arise during the total-order and partial-order planning, respectively. However, in this paper we focus on the causal graphs, since they were shown to be especially informative when all operators are unary (Jonsson & B¨ackstr¨om, 1998b; **Williams & Nayak, 1997).**
Causal graphs have an important potential role in the design **of autonomous industrial**
systems, as argued and demonstrated by Williams and Nayak (1997): Unary operators are natural when the manipulated objects are hardware components, since the basic control actions in such systems change the state of a single hardware **component. The applicability**
of these control actions in any state depends on the state of the affected component as well as on the state of the related hardware components. This **naturally gives rise to a**
planning domain with unary operators. Moreover, since the state variables correspond to hardware components, in the induced causal graph we typically see that the prevail dependencies between variables are usually implicitly entailed by the inter-composition of the hardware components. Thus, the causal graph of such domains resembles the structure of and the relationships between the system's hardware components. This resemblance has important practical ramifications for system design given the relationship between causal graph structure and the complexity of plan generation: It enables the system designer to consider the effect of his hardware design on the system's ability to autonomously generate control sequences.

A case in point is the planning problem studied by Williams and Nayak (1997), which had a number of important features: all operators were unary **and reversible, and the causal** graph was acyclic. Williams and Nayak argued that acyclic connectivity frequently occurs in designed systems. However, the requirement that all operators should be reversible seems to us restrictive, and it has important impact on the complexity of the problem. In the case of the Burton planner (Williams & Nayak, 1997), there were good reasons to make this assumption. Burton's reactive nature precludes extensive **deliberation on the consequences** of its operators. Thus it leaves open the possibility that operators may degrade the system's capabilities, leading it to dead-ends. In that case, the restriction to reversible operators was