required in order to achieve a more reliable system. As we show later, in certain cases, complete plans can be generated efficiently even when the operators are not reversible.

Williams and Nayak's work has another interesting aspect, as noted by Weld (1999).

For a long time, researchers have known that planning problems with serializable subgoals are likely to be easier to solve. Williams and Nayak recognized that their spacecraft configuration task was serializable (many real-world problems are not), and, more importantly, they developed a fast algorithm for computing the correct order based on the fact that the underlying causal graph is acyclic. However, their algorithm makes heavy use of the fact that all operators are reversible. Informally, reversibility implies that we can solve our subgoals one by one as long as they are consistent with some topological order of the causal graph without taking into account any global considerations: any side-effect can always be undone. Without the assumption of operator reversibility, it is relatively easy to show that Williams and Nayak's algorithm works only if the causal **graph forms a directed chain.**
Even when the causal graph is a tree, although the problem is easy, one must take care in the choice of which subgoal to achieve next when operators are not reversible. As we show later, when the structure of the causal graph is more complicated than a directed tree then either the problem is hard or, if not, a more sophisticated algorithm is required.

Finally, we note that the existence of reversible operators **might make the problem seem**
easier than it actually is. In this paper we present an example of a propositional planning problem with unary operators, acyclic causal graph, and totally reversible operators, the minimal solution of which is exponentially long in the size of the problem's description.

## 2.2 Example

In order to illustrate the notion of a causal graph, consider **the following example, inspired**
by the work of Williams and Nayak (1997) on controlling the main engine subsystem of the Cassini spacecraft, in general, and its valve driver circuitry, in particular.

Each valve V L (on/off) is controlled by a valve driver V LD **(open/close), and a safety**
control unit SCU **(safe/unsafe). Each driver controls exactly one valve, while a safety**
control unit can control several valves. Commands to the driver are sent via a driver control unit, that consist of two switches, S
l and S
r**, which can be either on or off. The**
activating states of S
l and S
r **are described below. A valve reacts (by a state change)**
to a command from its driver only if (i) the instruction actually involve a state change (i.e., an open valve should not be reopened), and (ii) the safety control unit indicates that manipulating the valve is safe. In addition, the valve can be **closed if the safety control unit** indicates an unsafe situation. For simplicity of presentation, Table 1 presents the operator set for controlling the valves and valve drivers only. The dashed boxes stand for driver control units, two switches in each.

Now suppose that the valves V L1 and V L2, with the drivers V LD1 and V LD2, respectively, are controlled by a shared safety control unit SCU**. Given the operator set in**
Table 1, the causal graph for controlling this subsystem is presented in Figure 1.

## 3. Polytree Causal Graphs

Starting at this section, we show how, by bounding the structural complexity of the causal graph, we can bound the complexity of plan generation. Recall that we use a propositional