(δ) Find a cheapest among the shortest plans.

Problem (α) is what we have already defined as optimal plans so far. We will now show how to express (β) in terms of optimal cost plans as well, and how to extend this elaboration with respect to the combinations (γ) and (δ).

5.1.1 CHEAPEST PLANS WITH GIVEN PLAN LENGTH (α)
As a guiding example, we refer to Blocks World with parallel moves allowed, where apart from finding shortest plans also minimizing the total number of moves is an issue. A Kcencoding for this domain, where plans are serializable, is shown in Figure 2. Serializability here means that parallel actions are non-interfering and can be executed sequentially in any order, i.e. the parallel plan can be arbitrarily "unfolded" to a sequential plan.

fluents : on(B, L) requires block(B), location(L).

blocked(B) requires block(B). moved(B) requires block(B).

actions : move(B, L) requires block(B), location(L) costs 1. always : executable move(B, L) if B != L.

nonexecutable move(B, L) if blocked(B).

nonexecutable move(B, L) if blocked(L). nonexecutable move(B, L) if move(B1, L), B < B1, block(L).

nonexecutable move(B, L) if move(B, L1), L < L1. nonexecutable move(B, B1) if move(B1, L). caused on(B, L) after move(B, L). caused blocked(B) if on(B1, B). caused moved(B) after move(B, L). caused on(B, L) if not moved(B) after on(B, L).

Figure 2: Kcencoding for the Blocks World domain The planning problem emerging from the initial state and the goal state depicted in Figure 3 can be modeled using the background knowledge Πbw:
block(1). block(2). block(3). block(4). block(5). block(6). location(table).

location(B) :- block(B).

and extending the program in Figure 2 as follows:
initially : on(1, 2). on(2, table). on(3, 4). on(4, table). on(5, 6). on(6, table).

goal : on(1, 3), on(3, table), on(2, 4), on(4, table), on(6, 5), on(5, table**) ?(**l)

![0_image_0.png](0_image_0.png)

Figure 3: A simple Blocks World instance