We represent this in Kcas follows. The background knowledge Π**T SP** defines two predicates city(C) and conn(F, T, C) representing the cities and their connections with associated costs. Connections can be traveled in both ways:
conn(brg, ibk, 2). conn(ibk, sbg, 2). conn(ibk, vie, 5). conn(ibk, kla, 3).

conn(sbg, kla, 2). conn(sbg, gra, 2). conn(sbg, lin, 1). conn(sbg, vie, 3). conn(kla, gra, 2). conn(lin, stp, 1). conn(lin, vie, 2). conn(lin, gra, 2). conn(gra, vie, 2). conn(gra, eis, 1). conn(stp, vie, 1). conn(eis, vie, 1). conn(stp, eis, 2). conn(vie, brg, 1).

conn(B, A, C) :- conn(A, B, C). city(T) :- conn(T, , ).

A possible encoding of TSP starting in Vienna (vie) is the Kc program in Figure 6. It includes two actions for traveling from one city to another and for directly returning to the starting point at the end of the round trip as soon as all cities have been visited.

actions : travel(X, Y) requires conn(X, Y, C) costs C.

return from(X) requires conn(X, vie, C) costs C.

fluents : unvisited. end.

in(C) requires city(C). visited(C) requires city(C).

always : executable travel(X, Y) if in(X).

nonexecutable travel(X, Y) if visited(Y). executable return from(X) if in(X). nonexecutable return from(X) if unvisited.

caused unvisited if city(C), not visited(C). caused end after return from(X). caused in(Y) after travel(X, Y).

caused visited(C) if in(C). inertial visited(C).

noConcurrency. initially : in(vie).

goal : end? (9)
Figure 6: Traveling Salesperson The problem has ten optimal 9-step solutions with cost 15. We show only the first five here, as the others are symmetrical:

| P1 = h {travel(vie, stp)},   | {travel(stp, eis)},   | {travel(eis, gra)},   | {travel(gra, lin)},   |
|------------------------------|-----------------------|-----------------------|-----------------------|
| {travel(lin, sbg)},          | {travel(sbg, kla)},   | {travel(kla, ibk)},   | {travel(ibk, brg)},   |
| {return from(brg)} i         |                       |                       |                       |
| P2 = h {travel(vie, eis)},   | {travel(eis, stp)},   | {travel(stp, lin)},   | {travel(lin, sbg)},   |
| {travel(sbg, gra)},          | {travel(gra, kla)},   | {travel(kla, ibk)},   | {travel(ibk, brg)},   |
| {return from(brg)} i         |                       |                       |                       |
| P3 = h {travel(vie, eis)},   | {travel(eis, stp)},   | {travel(stp, lin)},   | {travel(lin, gra)},   |
| {travel(gra, kla)},          | {travel(kla, sbg)},   | {travel(sbg, ibk)},   | {travel(ibk, brg)},   |
| {return from(brg)} i         |                       |                       |                       |
| P4 = h {travel(vie, lin)},   | {travel(lin, stp)},   | {travel(stp, eis)},   | {travel(eis, gra)},   |
| {travel(gra, kla)},          | {travel(kla, sbg)},   | {travel(sbg, ibk)},   | {travel(ibk, brg)},   |
