$\mathtt{l(step,lin)}$} $\mathtt{l(ijk,brg)}$}. 
$$\{\mathbf{a},\mathbf{e}\mathbf{i}\mathbf{s})\},$$
{return from(brg)} i P5 = h {travel(vie, gra)}, {travel(gra, eis)}, {travel(eis, stp)}, {travel(stp, lin)},
{travel(lin, sbg)}, {travel(sbg, kla)}, {travel(kla, ibk)}, {travel(ibk, brg)},
{return from(brg)} i TSP with variable costs. Let us now consider an elaboration of TSP, where we assume that the costs of traveling different connections may change during the trip. Note that three of the five solutions in our example above include traveling from St.P¨olten to Eisenstadt or vice versa on the second day. Let us now assume that the salesperson, who starts on Monday, has to face some exceptions which might increase the cost of the trip. For instance, (i) heavy traffic jams are expected on Tuesdays on the route from St.P¨olten to Eisenstadt or (ii) the salesperson shall not use the flight connection between Vienna and Bregenz on Mondays as only expensive business class tickets are available on this connection in the beginning of the week. So we have to deal with different costs for the respective connections depending on the particular day.

To this end, we first add to the background knowledge Π**T SP** a new predicate cost(A, B, W, C)
representing the cost C of traveling connection A to B on weekday W which can take exceptional costs into account:
cost(A, B, W, C) :- conn(A, B, C), \#int(W), 0 < W, W <= 7, not ecost(A, B, W). ecost(A, B, W) :- conn(A, B, C), cost(A, B, W, C1), C != C1.

The original costs in the predicate conn(A, B, C) now represent defaults, which can be overridden by explicitly adding different costs. For instance, to represent the exceptions (i) and (ii), we add:
cost(stp, eis, 2, 10). cost(vie, brg, 1, 10).

setting the exceptional costs for these two critical connections to 10. Weekdays are coded by integers from 1 (Monday) to 7 (Sunday). We represent a mapping from time steps to the weekdays by the following rules which we also add to Π**T SP** :
weekday(1, 1).

weekday(D, W) :- D = D1 + 1, W = W1 + 1, weekday(D1, W1), W1 < 7.

weekday(D, 1) :- D = D1 + 1, weekday(D1, 7).

Note that although the modified background knowledge Π**T SP** is not stratified (since cost is defined by cyclic negation), it has a total well-founded model, and thus a unique answer set.

Finally, we change the costs of traveling and returning in the Kc program from Figure 6:
actions : travel(X, Y) requires conn(X, Y, C1) costs C
where weekday(time, W), cost(X, Y, W, C).

return from(X) requires conn(X, vie, C1) costs C
where weekday(time, W), cost(X, vie, W, C).

Since now the costs for P1 (which includes traveling from St.P¨olten to Eisenstadt) on the second day have increased due to exception (i), only four of the plans from above remain optimal. Note that unlike the default costs, exceptional costs do not apply bidirectionally, so the exception does not affect P2 and P3. Furthermore, due to exception (ii) the symmetrical round trips starting with the flight trips to Bregenz are no longer optimal.

The presented encoding proves to be very flexible, as it allows for adding arbitrary exceptions for any connection on any weekday by simply adding the respective facts; moreover, even more involved scenarios, where exceptions are defined by rules, can be modeled.