
## 5.3 A Small Example For Planning Under Resource Restrictions

Although planning with resources is not the main target of our approach, the following encoding shows that action costs can also be used in order to model optimization of resource consumption in some cases. An important resource in real world planning is money. For instance, let us consider a problem about buying and selling (Lee & Lifschitz, 2001):
"I have $6 in my pocket. A newspaper costs $1 and a magazine costs $3. Do I have enough money to buy one newspaper and two magazines?"
In Kc, this can be encoded in a very compact way by the following background facts:
item(newspaper, 1). item(magazine, 2).

combined with the following short Kc program:
actions : buy(Item, Number) requires item(Item, Price), \#int(Number)
costs C where C = Number ∗ Price.

fluents : have(Item, Number) requires item(Item, Price), \#int(Number).

always : executable buy(Item, Number).

nonexecutable buy(Item, N1) if buy(Item, N2), N1 < N2. caused have(Item, Number) after buy(Item, Number).

goal : have(newspaper, 1), have(magazines, 2**) ? (**1)
The action buy is always executable, but one must not buy two different amounts of a certain item at once. Obviously, no admissible plan wrt. cost 6 exists, as the optimal plan for this problem, h{buy(newspaper, 1), buy(magazine, 2)} i has cost∗P = 7. Therefore, the answer to the problem is "no."
Our approach considers only positive action costs and does not directly allow modeling full consumer/producer/provider relations on resources in general, in favor of a clear non-ambiguous definition of optimality. For instance, by allowing negative costs one could always add a producer action to make an existing plan cheaper, whereas in our approach costs are guaranteed to increase monotonically, allowing for a clear definition of plan costs and optimality.

On the other hand, we can encode various kinds of resource restrictions by using fluents to represent these resources. We can then model production/consumption as action effects on these fluents and add restrictions as constraints. This allows us to model even complex resource or scheduling problems; optimization, however, remains restricted to action costs.

## 6. Transformation To Logic Programming

In this section, we describe how planning under action costs can be implemented by means of a transformation to answer set programming. It extends our previous transformation (Eiter et al.,
2003a), which maps ordinary K planning problems to disjunctive logic programs under the answer set semantics (Gelfond & Lifschitz, 1991), and takes advantage of weak constraints, cf. (Buccafurri, Leone, & Rullo, 1997, 2000), as implemented in the DLV system (Faber & Pfeifer, 1996; Eiter, Faber, Leone, & Pfeifer, 2000a). In addition, we show how this translation can be adapted to the language of Smodels (Simons, Niemel¨a, & Soininen, 2002).

## 6.1 Disjunctive Logic Programs With Weak Constraints

First, we give a brief review of disjunctive logic programs with weak constraints.