Basically, in lp(P) fluent and action literals are extended by an additional time parameter, and executability conditions as well as causations rules are modularly translated (rule by rule) into corresponding program rules and constraints; disjunction is used for guessing the actions which should be executed in the plan at each point in time.

6.2.1 REVIEW OF THE TRANSLATION lp(P)
The basic steps of the translation from K programs to logic programs are as follows (cf. (Eiter et al.,
2003a) for details):
Step 0 (Macro Expansion): First, replace all macros in the K program by their definitions.

Step 1 (Background Knowledge): The background knowledge Π of P is already given as a logic program and is included in lp(P), without further modification.

Step 2 (Auxiliary Predicates): To represent steps, we add the following facts to lp(P)
time(0)**., . . . ,** time(l). next(0, 1)**., . . . ,** next(l − 1, l).

where l is the plan length of the query q = G?(l) in P at hand.

Step 3 (Causation Rules): Causation rules are mapped to rules in lp(P) by adding type information and extending fluents and actions with a time stamp using time and next. For example, caused across(X) after cross(X), -across(X).

leads to rule across(X, T1) :- cross(X, T0), -across(X, T0), person(X), next(T0, T1).

in lp(P) where T1, T0 are new variables. Here, type information person(X) for across(X), and
-across(X), taken from the type declaration, is added, which helps to avoid unsafe logic programming rules. Step 4 (Executability Conditions): Similarly, each executability condition is translated to a disjunctive rule "guessing" whether an action occurs at a certain time step. In our running example, executable cross(X) if hasLamp(X).

becomes cross(X, T0) ∨ -cross(X, T0) :- hasLamp(X, T0), person(X), next(T0, T1).

which encodes a guess whether at time point T0 action cross(X) should happen; again, type information person(X) is added as well as next(T0, T1) to ensure that T0 is not the last time point.

Step 5 (Initial State Constraints): Initial state constraints are transformed like static causation rules in Step 3, but using the constant 0 instead of the variable T1 and thus need no auxiliary predicate for the time stamp. For instance, initially : caused -across(X).

becomes, by again adding the type information -across(X, 0) :- person(X).

Step 6 (Goal Query): Finally, the query q:
goal : g1(t1)**, . . . , g**m(tm), not gm+1(tm+1)**, . . . ,** not gn(tn**) ? (**l).

is translated as follows, where goal reached is a new 0-ary predicate symbol:
goal reached :- g1(t1, l), . . . , gm(tm, l), not gm+1(tm+1, l)**, . . . ,** not gn(tn, l).

:- not goal reached.