Corollary 6.3 (Answer set correspondence for admissible plans) For any well-defined Kc *planning problem* P = hPD, Q ? (l)i*, the trajectories* T = hhs0, A1, s1i*, . . . ,* hsl−1, Al, slii of admissible plans P for P wrt. cost c correspond to the answer sets S of lpw(P) *having* costlpw(P)(S) ≤ c, such that Aj = AS
j for all j = 1**, . . . , l** and sj = s S j
, for all j = 0**, . . . , l**.

As for secure planning, we have introduced a technique to check security of an optimistic plan for certain planning problem instances by means of a logic program (Eiter et al., 2003a). This method carries over to planning with action costs in a straightforward way, and optimal resp. admissible secure plans can be similarly computed by answer set programming.

## 6.3 Alternative Translation For Smodels

Apart from the presented translation using weak constraints, one could also choose an alternative approach for the translation to answer set programming. Smodels (Simons et al., 2002) supports another extension to pure answer set programming allowing to minimize over sets of predicates.

This approach could be used in an alternative formulation of Step 7:
Step 7a: For action declarations with nonempty costs-parts, we add a new rule of form cost(p, X1, . . . , Xn, 0, . . . , 0, T, Cθ) :- t1, . . . , tm, c1**θ, . . . ,** ckθ, U = T + 1. (6)
similar to Step 7 above, with two differences: (1) action name p is now a parameter, and (2) we add l − n parameters with constant "0" between Xn and T where l is the maximum arity of all actions in PD. This is necessary in order to get unique arity l + 2 for predicate cost. Furthermore, we add occurs(p, X1, . . . , Xn, 0, . . . , 0, T) :- p(X1, . . . , Xn, T), t1**, . . . ,** tm,. (7)
This second rule adds the same "0" parameters as for to achieve unique arity l + 1 of the new predicate occurs. Using Smodels syntax, we can now compute optimal plans by adding minimize[occurs(A, X1, ..., Xl, T) : cost(A, X1, ..., Xl, T, C) = C].

Note that Smodels does not support disjunction in rule heads, so we also need to modify Step 4, expressing the action guess via unstratified negation or Smodels' choice rules.

## 7. Implementation

We have implemented an experimental prototype system, DLVK, for solving K planning problems (Eiter et al., 2003a). An improved version of this prototype it is now capable of optimal and admissible planning with respect to the extended syntax of Kc, available for experiments at http://www.dlvsystem.com/K/ .

DLVK has been realized as a frontend to the DLV system (Faber & Pfeifer, 1996; Eiter et al.,
2000a). First, the planning problem at hand is transformed as described in the previous section.

Then, the DLV kernel is invoked to produce answer sets. For *optimistic planning* the (optimal, if action costs are defined) answer sets are then simply translated back into suitable output for the user and printed.

In case the user specified that *secure/conformant planning* should be performed, our system has to check security of the plans computed. In normal (non-optimal) planning, this is simply done by checking each answer set returned right before transforming it back to user output. In the case of