optimal secure planning, on the other hand, the candidate answer set generation of the DLV kernel has to be "intercepted": The kernel proceeds computing candidate answer sets, returning an answer set with minimal violation cost value, by running through all candidates. Here, in order to generate optimal secure plans, the planning frontend interrupts computation, allowing only answer sets which represent secure plans to be considered as candidates.

Checking plan security is done by rewriting the translated program wrt. the candidate answer set/plan in order to verify whether the plan is secure. The rewritten "check program" is tested by a separate invocation of the DLV kernel. As for further details on the system architecture we refer to (Eiter et al., 2003a)

## 7.1 Usage

Suppose the background knowledge and the program depicted in Figure 1 with the cost extensions from Section 3.3 are stored in files crossing.bk and crossing.plan; then, by invoking the program with the command line dlv − FPcrossing.plancrossing.bk− planlength = 7 we compute all optimal plans solving this problem in seven steps. In the output we find, after a supporting trajectory, the following optimal plan:
PLAN : crossTogether(joe, jack) : 2; cross(joe) : 1; takeLamp(william);
crossTogether(william, averell) : 10; takeLamp(jack); cross(jack) : 2; crossTogether(joe, jack) : 2 COST : 17 For each action, its cost is shown after a colon, if it is non-zero. The switch -planlength=i can be used to set the plan length; it overrides any plan length given in the query-part of the planing problem. Using -planlength=5, we get plans with cost 19, as there are no cheaper plans of that length.

The user is then asked whether to perform the optional security check and whether to look for further (optimal) plans, respectively. The switch -FPsec can be used instead of -FP to obtain secure plans only.

The command line option -costbound=N effects the computation of all admissible plans with respect to cost N. For example, the resource problem described in Section 5.3 can be solved by the following call to our prototype:
dlv − FPbuying.bkbuying.plan− N = 10 − planlength = 1 − costbound = 6 Correctly, no admissible plan is found. When calling the system again without cost bound, the prototype calculates the following optimal cost plan:
PLAN : buy(newspaper, 1) : 1, buy(magazine, 2) : 6 COST : 7 The current prototype supports simple bounded integer arithmetics. The option -N=10 used above sets an upper bound of N **= 10** for the integers which may be used in a program; the builtin predicate \#int is true for all integers 0 . . . N. Setting N high enough, taking into account the outcome of built-in arithmetic predicates A = B + C and A = B ∗ C, is important to get correct results. Further details on the prototype are given on the DLVK web site at http://www.

dlvsystem.com/K/.