
## 7.2 Experiments

Performance and experimental results for DLVK (without action costs and optimal planning) were reported in previous work (Eiter et al., 2003a). In this section, we present some encouraging experimental results for planning with action costs, in particular for parallel Blocks World and TSP. All experiments were performed on a Pentium III 733MHz machine with 256MB of main memory running SuSE Linux 7.2. We set a time limit of 4000 seconds for each tested instance where exceeding this limit is indicated by "-" in the result tables.

Where possible, we also report results for CCALC and CMBP, two other logic-based planning systems whose input languages (C+ resp. AR) have capabilities similar to K resp. Kc.

CCALC. The Causal Calculator *(CCALC*) is a model checker for the languages of causal theories
(McCain & Turner, 1997). It translates programs in the action language C+ into the language of causal theories which are in turn transformed into SAT problems; these are then solved using a SAT
solver (McCain & Turner, 1998). The current version of CCALC uses mChaff (Moskewicz et al.,
2001) as its default SAT solver. Minimal length plans are generated iteratively increasing the plan length up to an upper bound. CCALC is written in Prolog. For our tests, we used version 2.04b of CCALC which we obtained from <URL:http://www.cs.utexas.edu/users/tag/cc/
> and a trial version of SICStus Prolog 3.9.1. We used encodings taken from (Lee & Lifschitz, 2001) for parallel Blocks World adapted for CCALC 2.0. These encodings are included in the current download version of the system. For sequential Blocks World we adapted the encodings by adding the C+ command "noConcurrency." which resembles the respective K command. All results for CCALC include 2.30sec startup time.

CMBP. The *Conformant Model Based Planner* (CMBP) (Cimatti & Roveri, 2000) is based on the model checking paradigm and exploits symbolic Boolean function representation techniques such as Binary Decision Diagrams (Bryant, 1986). CMBP allows for computing sequential minimal length plans, where the user has to declare an upper bound for the plan length. Its input language is an extension of AR (Giunchiglia, Kartha, & Lifschitz, 1997). Unlike K or action languages such as C+ (Lee & Lifschitz, 2001), this language only supports propositional actions. CMBP is tailored for conformant planning. The results reported complement a previous comparison which also shows the encoding for sequential Blocks World in CMBP (Eiter et al., 2003a). For our tests, we used CMBP 1.0, available at <URL:http://sra.itc.it/people/roveri/cmbp/>.

## 7.2.1 Blocks World

Tables 1–4 show the results for our different Blocks World encodings in Section 5.1 on several configurations: P0 denotes our simple instance from Figure 3, while P1–P5 are instances used in previous work (Eiter et al., 2003a; Erdem, 1999).

Table 1 shows the results for finding a shortest sequential plan. The second and third column show the number of blocks and the length of a shortest plan (i.e., the least number of moves) solving the respective blocks world instance. The execution time for solving the problem using the shortestplan encoding Pβ in Section 5.1 is shown in column five, using the upper bound shown in the fourth column on the plan length. Column six shows the execution time for finding the shortest plan in an incremental plan length search starting from 0, similar to the method used for CCALC. The remaining two columns show the results for CCALC and CMBP.