
## Appendix A. The Language K

This appendix contains, in shortened form, the definition of the language K and a translation of K
to answer set programs; see (Eiter et al., 2003b, 2003a) for more details and examples.

## A.1 Basic Syntax

We assume σ act, σ f l, and σ typ disjoint sets of action, fluent and type names, respectively, i.e.,
predicate symbols of arity ≥ 0, and disjoint sets σ con and σ var of constant and variable symbols.

Here, σ f l, σ act describe *dynamic knowledge* and σ typ describes *static background knowledge*. An action (resp. fluent, type) atom is of form p(t1**, . . . , t**n), where p ∈ σ act (resp. σ f l, σ typ) has arity n and t1**, . . . , t**n ∈ σ con ∪ σ var. An action (resp. fluent, type) literal l is an action (resp. fluent, type)
atom a or its negation ¬a, where "¬" (alternatively, "–") is the true negation symbol. We define
¬.l = a if l = ¬a and ¬.l = ¬a if l = a, where a is an atom. A set L of literals is *consistent*, if L ∩ ¬.L = ∅. Furthermore, L
+ (resp. L
−) is the set of positive (resp. negative) literals in L. The set of all action (resp. fluent, type) literals is denoted as Lact (resp. Lf l, Ltyp). Furthermore, L**f l,typ**
= Lf l ∪ Ltyp, Ldyn= Lf l ∪ L+
act, and L = Lf l,typ ∪ L+
act.

All actions and fluents must be declared using statements as follows.

Definition A.1 (action, fluent declaration) An action *(resp.* fluent) declaration*, is of the form:*

$$m_{\mathrm{r}}$$

p(X1**, . . . , X**n) requires t1**, . . . , t**m (8)
where p ∈ L+
act *(resp.* p ∈ L+
f l), X1**, . . . , X**n ∈ σ var where n ≥ 0 *is the arity of* p, t1**, . . . , t**m ∈
Ltyp, m ≥ 0, and every Xi *occurs in* t1**, . . . , t**m.

If m = 0, the keyword requires may be omitted. Causation rules specify dependencies of fluents on other fluents and actions. Definition A.2 (causation rule) A causation rule (rule*, for short) is an expression of the form* caused f if b1**, . . . , b**k, not bk+1**, . . . ,** not bl after a1**, . . . , a**m, not am+1**, . . . ,** not an (9)
where f ∈Lf l∪{false}, b1, . . . , bl ∈Lf l,typ, a1**, . . . , a**nL, l≥k≥ 0*, and* n≥m≥ 0.

Rules where n = 0 are *static rules*, all others *dynamic rules*. When l = 0 (resp. n = 0), "if" (resp.

"after") is omitted; if both l = n = 0, "caused" is optional.

We access parts of a causation rule r by h(r) = {f}, post+(r) = {b1**, . . . , b**k}, post−(r) =
{bk+1**, . . . , b**l}, pre+(r) = {a1**, . . . , a**m}, pre−(r) = {am+1**, . . . , a**n}, and lit(r) = {f, b1**, . . . , b**l, a1**, . . . , a**n}. Intuitively, pre(r) = pre+(r) ∪ pre−(r) (resp. post(r) = post+(r) ∪ post−(r))
accesses the state before (resp. after) some action(s) happen.

Special static rules may be specified for the initial states.

Definition A.3 (initial state constraint) An initial state constraint *is a static rule of the form (9)*
preceded by "initially."
The language K allows conditional execution of actions, where several alternative executability conditions may be specified.