specifies a fluent describing that a specific person is on the other side of the river. Here the literals after "requires" must be classical literals of the static background knowledge (like person(X) and person(Y)), or literals of built-in predicates (such as X < Y). Our implementation of K, the DLVKsystem (Eiter, Faber, Leone, Pfeifer, & Polleres, 2003a), currently supports the built-in predicates
"A < B", "A <= B", "A != B" with the obvious meaning of less-than, less-or-equal and inequality for strings and numbers, the arithmetic built-ins "A = B + C" and "A = B ∗ C" which stand for integer addition and multiplication, and the predicate "\#int(X)" which enumerates all integers (up to a user-defined limit).

Causation rules. Causation rules ("rules" for brevity) are syntactically similar to rules of the action language C (Giunchiglia & Lifschitz, 1998; Lifschitz, 1999a; Lifschitz & Turner, 1999) and are of the basic form:
caused f if B after A.

where A is a conjunction of fluent and action literals, possibly including default negation, B is a conjunction of fluent literals, again possibly including default negation, and f is a fluent literal.

Informally, such a rule reads: if B is known to be true in the current state and A is known to be true in the previous state, then f is known to be true in the current state as well. Both the if-part and the after-part are allowed to be empty (which means that they are true). A causation rule is called dynamic, if its after-part is not empty, and is called *static* otherwise.

Causation rules are used to express effects of actions or ramifications. For example, caused across(X) after cross(X), -across(X). caused -across(X) after cross(X), across(X).

describe the effects of a single person crossing the bridge in either direction.

Initial state constraints. Static rules can apply to all states or only to the initial states (which may not be unique). This is expressed by the keywords "always :" and "initially :" preceding sequences of rules where the latter describes *initial state constraints* that must be satisfied only in the initial state. For example, initially : caused -across(X).

enforces the fluent across to be false in the initial state for any X satisfying the declaration of the fluent across, i.e., for all persons. The rule is irrelevant for all subsequent states.

Executability of actions. This is expressed in K explicitly. For instance, executable crossTogether(X, Y) if hasLamp(X). executable crossTogether(X, Y) if hasLamp(Y).

declares that two persons can jointly cross the bridge if one of them has a lamp. The same action may have multiple executability statements. A statement executable cross(X).

with empty body says that cross is always executable, provided that the type restrictions on X are respected. Dually, nonexecutable a if B.

prohibits the execution of action a if condition B is satisfied. For example, nonexecutable crossTogether(X, Y) if differentSides(X, Y).