For better readability, in the following we will not always describe K planning problems P
strictly in terms of sets of declarations, rules and executability conditions, but optionally use the more compact representation of K *programs* of the following general form:
fluents : FD actions : AD initially : IR always : CR
goal : q where the (optional) sections fluents through always consist of lists of fluent declarations FD, action declarations AD, initial state constraints IR and executability conditions and causation rules CR, respectively. Together with the background knowledge Π and the goal query q, they specify a K planning problem P = hhΠ,hD, Rii, qi, where D is given by FD plus AD and R by IR plus CR.

2

## 2.1 Solving The Bridge Crossing Problem

Using the above constructs, a K encoding of the Bridge Crossing Problem, assuming that joe initially carries the lamp, is shown in Figure 1. There are simple five-step plans (l **= 5)**, in which joe always carries the lamp and brings all others across. One of them is:
P = h {crossTogether(joe, jack)}, {cross(joe)}, {crossTogether(joe, william)},
{cross(joe)}, {crossTogether(joe, averell)} i

## 3. Actions With Costs

Using the language K and the system prototype, DLVK, we can already express and solve some involved planning tasks, cf. (Eiter et al., 2003b). However, K and DLVK alone offer no means for finding optimal plans under an objective cost function. In general, different criteria of plan optimality can be relevant, such as optimality wrt. action costs as shown in the next example, which is a slight elaboration of the Bridge Crossing Problem, and a well-known brain teasing riddle:
Problem 2 [Quick Bridge Crossing Problem] The persons in the bridge crossing scenario need different times to cross the bridge, namely 1, 2, 5, and 10 minutes, respectively. Walking in two implies moving at the slower rate of both. Is it possible that *all four persons get across within 17* minutes?

On first thought this is infeasible, since the seemingly optimal plan where joe, who is the fastest, keeps the lamp and leads all the others across takes 19 minutes altogether. Surprisingly, as we will see, the optimal solution indeed only takes 17 minutes.

In order to allow for an elegant and convenient encoding of such optimization problems, we extend K to the language Kcin which one can assign costs to actions.

## 3.1 Syntax Of Kc

Let σ act, σ f l, and σ var denote (finite) sets of action names, fluent names and variable symbols.

Furthermore, let Lact, Lf l, and Ltyp denote the sets of action, fluent, and type literals, respectively, 2. This is also the format of the input files of our system prototype, which will be presented in Section 7.