An action declaration d is *well-defined*, if all its legal instances are well-defined. This will be fulfilled if, in database terms, the variables X1**, . . . , X**n together with time in (1) functionally determine the value of C. In our framework, the semantics of a Kc planning domain PD = hΠ,h**D, R**ii is only well-defined for well-defined action declarations in PD. In the rest of this paper, we assume well-definedness of Kc unless stated otherwise.

Using **cost**i, we now define costs of plans.

Definition 3.4 Let P = hPD, Q ? (l)i *be a planning problem. Then, for any plan* P = hA1**, . . . , A**li for P*, its cost is defined as*

costP(P) = Plj=1 Pa∈Aj
$$=\sum_{j=1}^{l}\left(\sum_{a\in A_{j}}c o s t_{j}(a)\right)$$
.

A plan P is optimal for P*, if* costP(P) ≤ **cost**P(P
′) *for each plan* P
′for P, i.e., P has least cost among all plans for P. The cost of a planning problem P*, denoted* **cost**∗P
, is given by **cost**∗P =
costP(P
∗)*, where* P
∗*is an optimal plan for* P.

In particular, costP(P**) = 0** if P = hi, i.e., the plan is void. Note that **cost**∗P
is only defined if a plan for P exists.3 Usually one only can estimate some *upper bound* of the plan length, but does not know the exact length of an optimal plan. Although we have only defined optimality for a fixed plan length l, we will see in Section 5.1 that by appropriate encodings this can be extended to optimality for plans with length *at most* l.

Besides optimal plans, also plans with bounded costs are of interest, which motivates the following definition.

Definition 3.5 A plan P *for a planning problem* P is admissible wrt. cost c*, if* **cost**P(P)≤c.

Admissible plans impose a weaker condition on the plan quality than optimal plans. They are particularly relevant if optimal costs are not a crucial issue, as long as the cost stays within a given limit, and if optimal plans are difficult to compute. We might face questions like "Can I make it to the airport within one hour?", "Do I have enough change to buy a coffee?" etc. which amount to admissible planning problems. As we shall see, computing admissible plans is complexity-wise easier than computing optimal plans.

## 3.3 An Optimal Solution For The Quick Bridge Crossing Problem

To model the Quick Bridge Crossing Problem in Kc, we first extend the background knowledge as follows, where the predicate 'walk' describes the time a person needs to cross and 'max' determines which of two persons is slower:
walk(joe, 1). walk(jack, 2). walk(william, 5). walk(averell, 10).

max(A, B, A) :- walk( , A), walk( , B), A >= B. max(A, B, B) :- walk( , A), walk( , B), B > A.

Next, we modify the declarations for cross and crossTogether from Figure 1 by adding costs: