Action Introduction: When an action A is introduced into the planning graph, we (1) augment the event queue Q with events corresponding to all of A's effects, and (2) update the cost function C(**A, t**) of A.

Event Activation: When an event e = hfe, te, Ce, Ae**i ∈ Q**, which represents an effect of Ae occurring at time point te and adding a fact fe with cost Ce is activated, the cost function of the fact fe is updated if Ce < C(fe, te). Moreover, if the newly improved cost of fe leads to a reduction in the cost function of any action A that fe supports (as decided by function CostAggregate(**A, t**) in line 11 of Figure 5) then we will *(re)apply* A in the graph to propagate fe's new cost of achievement to the cost functions of A and its effects.

At any given time point t, C(**A, t**)is an aggregated cost (returned by function CostAggregate(**A, t**))
to achieve all of its preconditions. The aggregation can be done in different ways:

## 1. Max-Propagation: C(**A, T**) = M Ax{C(**F, T**) : F ∈ **P Recond**(A)} Or 2. Sum-Propagation: C(**A, T**) = P{C(**F, T**) : F ∈ **P Recond**(A)} Or

The first method assumes that all preconditions of an action depend on each other and the cost to achieve all of them is equal to the cost to achieve the costliest one. This rule leads to the underestimation of C(**A, t**) and the value of C(**A, t**) is admissible. The second method (*sum-propagation*)
assumes that all facts are independent and is thus inadmissible when subgoals have positive interactions. In classical planning scenarios, sum combination has proved to be more effective than the admissible but much less informed max combination (Nguyen et al., 2001; Bonet et al., 1997).

When the cost function of one of the preconditions of a given action is updated (lowered), the CostAggregate(**A, t**) function is called and it uses one of the methods described above to calculate if the cost required to execute an action has improved (been reduced).5If C(**A, t**) has improved, then we will *re-apply* A (line 12-14 in Figure 5) to propagate the improved cost C(**A, t**) to the cost functions C(**f, t**) of its effects.

The only remaining issue in the main algorithm illustrated in Figure 5 is the *termination criteria* for the propagation, which will be discussed in detail in Section 3.3. Notice that the way we update the cost functions of facts and actions in the planning domains described above shows the challenges in heuristic estimation in temporal planning domains. Because an action's effects do not occur instantaneously at the action's starting time, concurrent actions overlap in many possible ways and thus the cost functions, which represent the difficulty of achieving facts and actions are time-sensitive.

Before demonstrating the cost propagation process in our ongoing example, we make two observations about our propagated cost function:
Observation 1: *The propagated cost functions of facts and actions are non-increasing over time.*
Observation 2: *Because we increase time in* steps by going through events in the event queue, the cost functions for all facts and actions will be step-functions, even though time is measured continuously.