the goals. From those intuitions, following are several rules that can be used to determine when to terminate propagation:
Deadline termination: The propagation should stop at a time point t *if: (1)* ∀ goal G : **Deadline**(G) ≤ t*, or (2)* ∃ **goal G** : (Deadline(G) < t) ∧ (C(**G, t**) = ∞).

The first rule governs the hard constraints on the goal deadlines. It implies that we should not propagate beyond the latest goal deadline (because any cost estimation beyond that point is useless), or we can not achieve some goal by its deadline.

With the observation that the propagated costs can change only if we still have some events left in the queue that can possibly change the cost functions of a specific propositions, we have the second general termination rule regarding the propagation:
Fix-point termination: *The propagation should stop when there are no more events that can decrease the cost of any proposition.*
The second rule is a qualification for reaching the fix-point in which there is no gain on the cost function of any fact or action. It is analogous to the idea of growing the planning graph until it levels-off in classical planning.

Stopping the propagation according to the two general rules above leads us to the best (lowest value) achievable cost estimation for all propositions given a specific initial state. However, there are several situations in which we may want to stop the propagation process earlier. First, propagation until the fix-point, where there is no gain on the cost function of any fact or action, would be too costly (c.f., Nguyen et al., 2001). Second, the cost functions of the goals may reach the fixpoint long before the full propagation process is terminated according to the general rules discussed above, where the costs of all propositions and actions stabilize.

Given the above motivations, we introduce several different criteria to stop the propagation earlier than is entailed by the fix-point computation:
Zero-lookahead approximation: Stop the propagation at the earliest time point t *where all the* goals are reachable (C(**G, t**) < ∞).

One-lookahead approximation: At the earliest time point t where all the goals are reachable, execute all the remaining events in the event queue and stop the propagation.

One-lookahead approximation looks ahead one step in the (future) event queues when one path to achieve all the goals under the relaxed assumption is guaranteed and hopes that executing all those events would explicate some cheaper path to achieve all goals.6 Zero and one-lookahead are examples of a more general k-lookahead approximation, in which extracting the heuristic value as soon as all the goals are reachable corresponds to *zero-lookahead* and continuing to propagate until the fix-point corresponds to the *infinite (full) lookahead*. The rationale behind the k-lookahead approximation is that when all the goals appear, which is an indication that there exists at least one (relaxed) solution, then we will look ahead one or more steps to see if we can achieve some extra improvement in the cost of achieving the goals (and thus lead to a lower cost solution).7