Coming back to our travel example, zero-lookahead stops the propagation process at the time point t = 2.5 and the goal cost is C(in la, 2.5) = 8.0. The action chain giving that cost is
{D
c1 t→p
, Fp→la}. With one-lookahead, we find the lowest cost for achieving the goal in la is C(in la, 7.0) = 6.0 and it is given by the action (D
c2 t→la). With two-lookahead approximation, the lowest cost for in la is C(in la, 6.0) = 5.5 and it is achieved by cost propagation through the action set {(D
c1 t→lv, Tlv→la)}. In this example, two-lookahead has the same effect as the fix-point propagation (infinite lookahead) if the deadline to achieve in la is later than t = 6.0. If it is earlier, say Deadline(in la) = 5.5, then the one-lookahead will have the same effect as the infinite-lookahead option and gives the cost of C(in la, 3.0) = 7.5 for the action chain {D
c2 t→phx, Fphx→la}.

## 4. Heuristics Based On Propagated Cost Functions

Once the propagation process terminates, the time-sensitive cost functions contain sufficient information to estimate any makespan and cost-based heuristic value of a given state. Specifically, suppose the planning graph is grown from a state S. Then the cost functions for the set of goals G = {(g1, t1),(g2, t2)...(gn, tn)}, ti = **Deadline**(gi) can be used to derive the following estimates:

- The minimum makespan estimate T(PS) for a plan starting from S is given by the earliest time point τ0 at which all goals are reached with finite cost C(**g, t**) < ∞.

- The minimum/maximum/summation estimate of slack **Slack**(PS) for a plan starting from S
is given by the minimum/maximum/summation of the distances between the time point at which each goal first appears in the temporal planning graph and the deadline of that goal.

- The minimum cost estimate, (C(**g, deadline**(g))), of a plan starting from a state S and achieving a set of goals G, C(PS, τ∞), can be computed by aggregating the cost estimates for achieving each of the individual goals at their respective deadlines.8 Notice that we use τ∞ to denote the time point at which the cost propagation process stops. Thus, τ∞ is the time point at which the cost functions for all individual goals C(**f, τ**∞) have their lowest value.

- For each value t : τ0 **< t < τ**∞, the cost estimate of a plan C(PS, t), which can achieve goals within a given makespan limit of t, is the aggregation of the values C(gi, t) of goals gi.
The makespan and the cost estimates of a state can be used as the basis for deriving heuristics.

The specific way these estimates are combined to compute the heuristic values does of course depend on what the user's ultimate objective function is. In the general case, the objective would be a function f(C(PS), T(PS)) involving both the cost (C(PS)) and makespan (T(PS)) values of the plan. Suppose that the objective function is a linear combination of cost and makespan:
h(S) = f(C(PS), T(PS)) = α.C(PS) + (1 − α).T(PS)
If the user only cares about the makespan value (α = 0), then h(S) = T(PS) = τ0. Similarly, if the user only cares about the plan cost (α = 1), then h(S) = C(PS, τ∞). In the more general