- Compared to classical planners, which only have to handle the logical constraints between actions, metric temporal planners have to deal with many additional types of constraints that involve time and continuous functions representing different types of resources.

- In contrast to classical planning, where the only objective is to find shortest length plans, metric temporal planning is *multi-objective*. The user may be interested in improving either temporal quality of the plan (e.g. makespan) or its cost (e.g. cumulative action cost, cost of resources consumed etc.), or more generally, a combination thereof. Consequently, effective plan synthesis requires heuristics that are able to track both these aspects in an evolving plan.

Things are further complicated by the fact that these aspects are often inter-dependent. For example, it is often possible to find a "cheaper" plan for achieving goals, if we are allowed more time to achieve them.
In this paper, we present Sapa, a heuristic metric temporal planner that we are currently developing to address these challenges. Sapa is a forward chaining planner, which searches in the space of time-stamped states Sapa handles durative actions as well as actions consuming continuous resources. Our main focus has been on the development of heuristics for focusing Sapa's multi-objective search. These heuristics are derived from the optimistic reachability information encoded in the planning graph. Unlike classical planning heuristics (c.f., Nguyen et al., 2001)),
which need only estimate the "length" of the plan needed to achieve a set of goals, Sapa's heuristics need to be sensitive to both the cost and length ("makespan") of the plans for achieving the goals.

Our contributions include:

- We present a novel framework for tracking the cost of literals (goals) as a function of time.

These "cost functions" are then used to derive heuristics that are capable of directing the search towards plans that satisfy any type of cost-makespan tradeoffs.

- Sapa generalizes the notion of "phased" relaxation used in deriving heuristics in planners such as AltAlt and FF (Nguyen et al., 2001; Hoffmann & Nebel, 2001). Specifically, the heuristics are first derived from a relaxation that ignores the delete effects and metric resource constraints, and are then adjusted subsequently to better account for both negative interactions and resource constraints.

- Sapa improves the temporal flexibility of the solution plans by post-processing these plans to produce order constrained (o.c or partially-ordered) plans. This way, Sapa is able to exploit both the ease of resource reasoning offered by the position-constrained plans and the execution flexibility offered by the precedence-constrained plans. We present a linear time greedy approach to generate an o.c plan of better or equal makespan value compared to a given p.c plan.
Architecture of Sapa: Figure 1 shows the high-level architecture of Sapa. Sapa uses a forward chaining A* search to navigate in the space of time-stamped states. Its evaluation function (the
"f(.)" function is multi-objective and is sensitive to both makespan and action cost. When a state is picked from the search queue and expanded, Sapa computes heuristic estimates of each of the resulting children states. The heuristic estimation of a state S is based on (i) computing a relaxed temporal planning graph (RTPG) from S, (ii) propagating cost of achievement of literals in the