
## 4.3 Origin Of Action Costs

In all our preceding discussion of cost-based heuristics, we have implicitly assumed that the individual action costs are specified directly as part of the problem specification. While this is a reasonable assumption, it can also be argued that unlike the duration, the cost of an action is implicitly dependent on what the user is interested in optimizing. For example, suppose, in a transportation domain, the user declares the objective function to be optimized as:10 4 ∗ T**otalT ime** + 0.005 ∗ T**otalF uelUsed**
without providing any additional explicit information about action costs. It is possible to use the objective function to assess the costs of individual actions (in terms of how much they contribute to the cost portion of the objective). Specifically, the cost each action can be set equal to the amount of fuel used by that action. The α value (for combining cost and makespan) can be set based on the coefficients in the objective function. Of course, this type of "de-compilation" of the objective function into action costs is only possible if the objective function is a linear combination of makespan and resource consumption.

## 5. Adjustments To The Relaxed Plan Heuristic

Until now, the heuristic estimates have been calculated by relaxing certain types of constraints such as negative effects and metric resource consumptions. In this section, we discuss how those contraints can then be used to adjust and improve the final heuristic values.

## 5.1 Improving The Relaxed Plan Heuristic Estimation With Static Mutex Relations

When building the relaxed temporal planning graph (RTPG), we ignored the negative interactions between concurrent actions. We now discuss a way of using the static mutex relations to help improve the heuristic estimation when extracting the relaxed plan. Specifically, our approach involves the following steps:

1. Find the set of static mutex relations between the ground actions in the planning problem based on their negative interactions.11 2. When extracting the relaxed plan (Section 4.2), besides the orderings between actions that have causal relationships (i.e one action gives the effect that supports the other action's preconditions), we also post precedence constraints to avoid concurrent execution of actions that are mutex. Specifically, when a new action is added to the relaxed plan, we use the precalculated static mutexes to establish ordering between mutually exclusive action pairs so that they can not be executed concurrently. The orderings are selected in such a way that they violate the least number of existing causal links in the relaxed plan.
By using the mutex relations in this way, we can improve the makespan estimation of the relaxed plan, and thus the heuristic estimation. Moreover, in some cases, the mutex relations can also help us detect that the relaxed plan is in fact a valid plan, and thus can lead to the early termination