In the second set of problems, which come with temporal constraints, there are three domains:
Depots, *DriverLogistics* and *Zeno Travel*. Sapa participated at the highest level, which is the
"timed" settings for these three domains. Figure 20 shows the comparison between Sapa and three other planners (LPG, MIPS, and TP4) that submitted results in the *Depots* domain. In this domain, we need to move crates (packages) between different places. The loading actions that place the crates into each truck are complicated by the fact that they need an *empty* hoist. Thus, the *Depot* domain looks like a combination of the original logistics and blockworlds domains. Drive action durations depend on the distances between locations and the speed of the trucks. Time for loading the crates depends on the power of the hoist that we use. There is no resource consumption in this highest level. In this domain, Sapa was only able to solve five problems, compared to 11 by MIPS
and 18 by LPG. TP4 solved only one problem. For the five problems that Sapa was able to solve, the solution quality is as good as other planners. For the speed comparison, LPG with *speed* setting is clearly faster than the other planners. We speculate that the poor performance of Sapa in this domain is related to two factors: (i) negative interactions between subgoals, largely ignored by Sapa, are an important consideration in this domain and (ii) the number of ground actions in this domain is particularly high, making the computation of the planning graph quite costly.

Figure 21 shows how Sapa performance compares with other planners in the competition on the time setting of the *DriveLog* domain. This is a variation of the original *Logistics* domain in which trucks rather than airplanes move packages between different cities. However, each truck requires a driver, so a driver must walk to and board a truck before it can move. Like the *Depot* domain, there is no resource consumption. The durations for walking and driving depend on the specified *timeto-walk* and *time-to-drive*. In this domain, Sapa solved 14 problems compared to 20 by LPG, 16 by MIPS and 1 by TP4. The quality of the solutions by different planners are very similar. For the speed comparison, LPG with *speed* setting is fastest, then MIPS, then Sapa and LPG with *quality* setting.

Finally, Figure 22 shows the performance of Sapa in the ZenoTravel domain with *time* setting.

In this domain, passengers travel between different cities by airplanes. The airplanes can choose to fly with different speeds (fast/slow), which consume different amounts of fuel. Airplanes have different fuel capacity and need to refuel if they do not have enough for each trip. In this domain, Sapa and LPG solved 16 problems while MIPS solved 20. The solution quality of Sapa and MIPS
are similar and in general better than LPG with either speed or *quality* setting. LPG with *speed* setting and MIPS solved problems in this domain faster than Sapa which is in turn faster than LPG
with *quality* setting.

In summary, for problems involving both metric and temporal constraints in IPC3, Sapa is competitive with other planners such as LPG or MIPS. In particular, Sapa solved the most problems and returned the plans with best solution quality in the highest setting for the two domains *Satellite* and *Rovers*, which are adapted from NASA domains. A more detailed analysis of the competition results is presented by Long and Fox (2003).

## 9. Related Work And Discussion

Although there have been several recent domain-independent heuristic planners aimed at temporal domains, most of them have been aimed at makespan optimization, ignoring the cost aspects. For example, both TGP (Smith & Weld, 1999) as well as TP4 (Haslum & Geffner, 2001) focus on makespan optimization and ignore the cost aspects of the plan. As we have argued in this paper,