stamp (where presumably other actions have already been applied; thus allowing concurrency) and
(b) advancement of the current time stamp.

Sapa's search is thus conducted through the space of time stamped states. We define a time stamped state S as a tuple S = (P, M, Π**, Q, t**) consisting of the following structure:

- P = (hpi, tii | ti ≤ t) is a set of predicates pithat are true at t and tiis the last time instant at which they were achieved.

- M is a set of values for all continuous functions, which may change over the course of planning. Functions are used to represent the metric-resources and other continuous values. Examples of functions are the fuel levels of vehicles.

- Π is a set of persistent conditions, such as durative preconditions, that need to be protected during a specific period of time.

- Q is an event queue containing a set of updates each scheduled to occur at a specified time in the future. An event e can do one of three things: (1) change the True/False value of some predicate, (2) update the value of some function representing a metric-resource, or (3) end the persistence of some condition.

- t is the time stamp of S
In this paper, unless noted otherwise, when we say "state" we mean a time stamped state. Note that a time stamped state with a stamp t not only describes the expected snapshot of the world at time t during execution (as done in classical progression planners), but also the delayed (but inevitable)
effects of the commitments that have been made by (or before) time t.

The initial state S**init** has time stamp t = 0 and has an empty event queue and empty set of persistent conditions. It is completely specified in terms of function and predicate values. The goals are represented by a set of 2-tuples G = (hp1, t1i...hpn, tni) where piis the i th goal and tiis the time instant by which pi needs to be achieved. Note that PDDL2.1 does not allow the specification of goal deadline constraints.

Goal Satisfaction: The state S = (P, M, Π**, Q, t**) *subsumes* (entails) the goal G if for each hpi, tii ∈
G either:
1. ∃hpi, tj i ∈ P, tj < ti and there is no event in Q that deletes pi. 2. ∃e ∈ Q that adds pi at time instant te < ti, and there is no event in Q that deletes pi.

1

Action Applicability: An action A is *applicable* in state S = (P, M, Π**, Q, t**) if:
1. All logical (pre)conditions of A are satisfied by P.

2. All metric resource (pre)conditions of A are satisfied by M. (For example, if the condition to execute an action A = move(truck, A, B) is f uel(**truck**) > 500 then A is executable in S if the value v of f uel(**truck**) in M satisfies v > 500.)