For instance, consider Example 5.1. Turning the first list in C of (5) into [1,1,1] would still allow for generating the formula (2), but it would allow for generating also unary clauses at top level with probability 1  (2=3)L, which converges quickly to 1 with L.

Usually we are not interested in randomly generating one precise formula with some non-zero probability —which would be rather small anyway— but rather to randomly generate a class of formulae which are as similar as possible a given target class of formulae. Adding redundant non-zeros would extend the range of shapes for formulae, extending the variance and lowering the resemblance to the target class of formulae.

## 7. Discussion 7.1 The Basic And The Advanced Method

Our new testing method can be used at two different levels, depending on the attitude —and on the skills and experience— of the user.

In the *basic* usage the clause length C is represented by lists with either only one non-zero element (e.g., [[0,0,1]], meaning "clause length 2") or only two adjacent non-zero elements
(e.g., [[0,2,1]], meaning "clause length 2 or 3, with probability 2=3 and 1=3 respectively");
similarly, the propositional/modal rate p is represented by lists with either only one non-zero element
(e.g., [[[],[],[0,1,0,0]]], meaning "1 propositional literal per clause") or only two nonzero adjacent elements (e.g., [[[],[],[0,3,2,0]]], meaning "either 1 or 2 propositional literals per clause, with probability 3=5 and 2=5 respectively"); the distributions do not vary with the depth.

In the basic way the random generator is used as a "flawless"10 extension of the 3CNF2m method of Giunchiglia and Sebastiani (1996), which allows for setting the clause length to either fixed integer values or to non-integer average values. The number of parameters is kept relatively small, so that to allow a coarse-grained coverage of a significant subspace with an affordable number of tests.

In the *advanced* usage, it is possible to apply any finite probability distributions to both C and p; moreover, it is possible to use different distributions at different depths. This opens a huge amount of possibilities, but requires some skills and experience from the user: the representation of sophisticated multi-level distributions may be rather complicated, and may thus require some practice; moreover, the usage of complex distributions requires some care, as the presence non-constant distributions in both clause length and propositional/modal rate may significantly enlarge the variance of the features of the generated formulae, making the effects of the tests more unpredictable and instance-dependent.

In order to guide the user, we provide some general suggestions for choosing the parameter sets in a testing session. They come from both theoretical issues and our practical experience in using the generator.

 Avoid generating purely propositional top-level clauses, that is, set p = [[...,0],...].

See Sections 4.1 and 5.1. If possible, avoid generating unary top-level clause, that is, set C
= [[0,...],...]). See also Section 7.5.