Termination: The new method allows for generating test sets of up to depth 3-4 which are run by state-of-the-art systems in a reasonable amount of time.

Reproducibility: The results of each testbed are easy to reproduce because the generator's code and all the parameters' values are made publicly available.

Parameterization: The random generation of CNF2m formulae is fully parametric.

Data organization: The most natural way to use the new random generator is to generate tests and plot data by increasing values of one or two parameters. This allows for easy, quantitative and qualitative evaluations of the performances of the different procedures under test.

Moreover, the new method improves the 3CNF2m method for the following features.

Representativeness: As stated in Section 6, CNF2m formulae represent all formulae in the normal modal logics from K(m) upward, as there is an equivalence-preserving way of converting all modal formulae into CNF2m. From Theorem 6.1, the new method allows for a very finegrained sampling of the class of CNF2m formulae.

Difficulty: The random CNF2m formulae with d  2 and N  4 provide challenging test sets for state-of-the art procedures. CNF2m formulae with d  4 and N  9 can be well considered as challenges for next-generation systems. (Of course, it is not a problem to generate easy problems too.)
Control: The parameters N, d and C allow for controlling *monotonically* the difficulty of the test set. (E.g., if you increase N, you are reasonably sure that your mean/median CPU time plots will increase.) The parameter L allows for controlling the satisfiability rate. Monotonicity allows for controlling one feature by simply increasing or decreasing one value, and thus for eliminating uninteresting areas of the input space.

Modal vs. propositional balance: The size of the Kripke models spanned by the decision procedures has increased exponentially with the higher modal depths reached by the new test sets; moreover, the probability of repeated top-level atoms has dramatically reduced.11 Consequently, unlike the tests by Hustadt and Schmidt (1999) and Giunchiglia et al. (2000) the search is no longer dominated by the pure propositional component of reasoning, and the empirical results show that a large number of modal successors are explored.

Finally, the new method completely removes or drastically reduces the effects of the following problems.

Redundancy: Propositional and modal redundancy had already been eliminated in the last versions of the 3CNF2m method (Giunchiglia et al., 2000). Moreover, the new method allows for eliminating all strictly propositional clauses.

Triviality: The main cause of trivial unsatisfiability has been removed, so that trivially unsatisfiable formulae have been relegated out of the transition areas in our experiments.