
## 7.4 Complexity Issues

From a purely theoretical viewpoint, it is remarked that modal-encoded QBF formulae can capture the problems in P
D, while CNF2m formulae are "stuck at NP" (Massacci, 1999)15. This statement requires some clarification.

First, test sets are necessarily *finite*, therefore it makes no sense to attribute to them a complexity class. Thus, when speaking of complexity classes for test problems, we do not refer to test sets, but rather to the *infinite* sets of formulae we could generate if we could have *unbounded* values for (at least one of) the generation parameters. In particular, the statement above means that the infinite set of QBF formulae with unbounded number of variables per alternation V and bounded alternation depth D is complete for P
D (Garey & Johnson, 1979), while the infinite set of CNF2m formulae with bounded depth and unbounded number of propositional variables is in NP (Halpern, 1995).

Secondly, the alternation depth D and the variable number per alternation V are not the "QBFanalogous" of K(m)'s modal depth and variable number respectively, as both the latter values for the resulting modal formulae grow as O(D  V ).

16 In fact, QBF formulae with bounded alternation depth D and unbounded number of variables per alternation V give rise to modal formulae of both unbounded depth and unbounded number of variables.

Finally, the "P
D vs. NP" issue of Massacci (1999) is not a matter of generators, but rather a matter of how such generators are used, and of how results are organized and presented. In fact, so far random CNF2m testbeds have always been organized by fixing all the parameters except L
(modal depth d included!) and making L vary. This choice, whose goal is to produce data plots covering the satisfiability transition area, is what causes the testbed formulae to be "stuck at NP". To avoid this fact, one may want to make d vary and to fix all the other parameters, as K(m)

satisfiability with unbounded depth and bounded number of propositional variables is PSPACEcomplete (Halpern, 1995).

## 7.5 Asymptotic Behavior

Achlioptas et al. (1997) presented a study on the *asymptotic behavior* of random CSP problems. They showed that, for most well-known random generation models (which did not reveal flaws in empirical tests) the probability that problems are trivially unsatisfiable tends to 1 with N 7! 1, N being the number of variables. Gent et al. (2001) lately explained this discrepancy between theoretical and empirical results by showing that the above phenomenon happens with significant probability only for values of N which are out of the reach of current CSP solvers.

The problem is due to the possible presence of (implicit) *unary constraints* causing some variable's value to be inadmissible. If this occurs with some non-zero probability, then with non-zero probability some variable may have all its values inadmissible. This causes a "local" inconsistency of the whole problem, which is very easily revealed by the solver. When N 7! 1, the probability of not having such situation tends to zero. Analogous problems have been revealed with random SAT problems generated with the constant probability generation model, as unary clauses are gen-