problems, e.g., to test the effectiveness of some redundancy elimination technique, or satisfiable problems only, e.g., to test incomplete procedures. To this extent, the key issue here is having a reasonable form of control over these features, so that one can address not only general-purpose criteria, but also specific desiderata.

Second, in some cases, there may be a tradeoff between two distinct criteria, so that it may be necessary to choose only one of them, or to make a compromise. One example is given by redundancy and artificiality: in some real-world problems large parts of the knowledge base are irrelevant for the query, whose result is determined by a small subpart of the input; in this sense eliminating such "redundancies" may make problems more "artificial".

Particular attention must be paid to the problem of triviality, as it has claimed victims in many areas of AI. In fact, flaws (i.e., inadvertent trivial problems) have been detected in random generators for SAT (Mitchell, Selman, & Levesque, 1992), CSP (Achlioptas, Kirousis, Kranakis, Krizanc, Molloy, & Stamatiou, 1997; Gent, MacIntyre, Prosser, Smith, & Walsh, 2001), modal reasoning (Hustadt & Schmidt, 1999) and QBF (Gent & Walsh, 1999). Thus, the notion of "trivial" (and thus
"flawed") deserves more comment.

In the work by Achlioptas et al. (1997) flawed problems are those solvable in linear time by standard CSP procedures, due to the undesired presence of implicit unary constraints causing some variable's value to be inadmissible. A similar notion holds for SAT (Mitchell et al., 1992) and QBF
(Gent & Walsh, 1999). In the literature of modal reasoning, instead, the typical flawed problems are those whose (un)satisfiability can be verified directly at propositional level, that is, without investigating any modal successors; this kind of problems are typically solved in negligible time w.r.t. other problems of similar size and depth (Hustadt & Schmidt, 1999; Giunchiglia et al., 2000; Horrocks et al., 2000).3 Thus, with a little abuse of notation and when not otherwise specified, in this paper we will call *trivially (un)satisfiable* the problems of this kind.4

## 3. An Overview Of The State-Of-The-Art

Previous empirical tests have mostly been generated by three methods: hand-generated formulae
(Heuerding & Schwendimann, 1996), randomly-generated clausal modal formulae (Giunchiglia &
Sebastiani, 1996; Hustadt & Schmidt, 1999; Giunchiglia et al., 2000), and randomly-generated quantified boolean formulae that are then translated into modal formulae (Massacci, 1999).

We have already presented a detailed analysis of these three methods (Horrocks et al., 2000).

Here we present only a quick overview of the latter two methods, as we will refer to them in following sections.5

## 3.1 The 3Cnf2M Random Tests

In the 3CNF2m test methodology (Giunchiglia & Sebastiani, 1996; Hustadt & Schmidt, 1999; Giunchiglia et al., 2000), the performance of a system is evaluated on sets of randomly generated 3CNF2m formulae. A CNF2m formula is a conjunction of CNF2m clauses, where each clause