is a disjunction of either propositional or modal literals. A literal is either an atom or its negation.

Modal atoms are formulae of the form 2iC, where C is a CNF2m clause. A 3CNF2m formula is a CNF2m formula where all clauses have exactly 3 literals.

## 3.1.1 The Random Generator

A 3CNF2m formula is randomly generated according to five parameters: the (maximum) modal depth d; the number of clauses in the top-level conjunction L; the number of propositional variables N; the number of distinct box symbols m; and the probability p of an atom occurring in a clause at depth < d being purely propositional.

The random 3CNF2m generator, in its final version (Giunchiglia et al., 2000), works as follows:

 a 3CNF2m formula of depth d is produced by randomly generating L 3CNF2m clauses of depth d, and forming their conjunction; a 3CNF2m clause of depth d is produced by randomly generating three distinct, under commutativity of disjunction, 3CNF2m atoms of depth d, negating each of them with probability 0.5, and forming their disjunction; a propositional atom is produced by picking randomly an element of fA1; : : : ; AN g with uniform probability; a 3CNF2m atom of depth d > 0 is produced by generating with probability p a random propositional atom, and with probability 1  p a 3CNF2m atom 2rC, where 2r is picked randomly in f21; : : : ; 2mg and C is a randomly generated 3CNF2m clause of depth d  1.
Recently Horrocks and Patel-Schneider (2002) have proposed a variant of the 3CNF2m random generator of Giunchiglia et al. (2000). They added four extra parameters: np and nm, representing respectively the probability that a propositional and modal atom is negated, and min and max, representing respectively the minimum and maximum number of modal literals in a clause, with equal probability for each number in the range. For their experiments, they always set np = 0:5 and min = 
max = 3. To this extent, 3CNF2m formulas can be generated as in the generator of Giunchiglia et al. (2000) by setting np = nm = 0:5 and min = 
max = 3.

## 3.1.2 Test Method & Data Analysis

The 3CNF2m test method works as follows. A typical problem set is characterized by a fixed N, m, d and p: L is varied in such a way as to empirically cover the "100% satisfiable—100%
unsatisfiable" transition. Then, for each tuple of the parameters' values (*data point* from now on)
in a problem set, a certain number of 3CNF2m formulae are randomly generated, and the resulting formulae are given in input to the procedure under test, with a maximum time bound. Satisfiability rates, median/percentile values of the CPU times, and median/percentile values of other parameters, e.g., number of steps, memory, etc., are plotted against the number of clauses L or the ratio of clauses to propositional variables L=N.

## 3.2 The Random Qbf Tests

In QBF-based benchmarks (such as part of the TANCS'99 benchmarks (Massacci, 1999)), system performances are evaluated on sets of random quantified boolean formulae, which are gener-