# Altaltp**: Online Parallelization Of Plans With** Heuristic State Search

Romeo Sanchez Nigenda **rsanchez@asu.edu**
Subbarao Kambhampati **rao@asu.edu**
Department of Computer Science and Engineering, Arizona State University, Tempe AZ 85287-5406

## Abstract

Despite their near dominance, heuristic state search planners still lag behind disjunctive planners in the generation of parallel plans in classical planning. The reason is that directly searching for parallel solutions in state space planners would require the planners **to branch**
on all possible subsets of parallel actions, thus increasing the branching factor **exponentially.**
We present a variant of our heuristic state search planner AltAlt **called** AltAltp **which**
generates parallel plans by using greedy online parallelization of partial plans. The greedy approach is significantly informed by the use of novel distance heuristics that AltAltp derives from a graphplan-style planning graph for the problem. While this approach is not guaranteed to provide optimal parallel plans, empirical results show that AltAltpis capable of generating good quality parallel plans at a fraction of the cost incurred by the disjunctive planners.

## 1. Introduction

Heuristic state space search planning has proved to be one of **the most efficient planning** frameworks for solving large deterministic planning problems (Bonet, Loerincs, & Geffner, 1997; Bonet & Geffner, 1999; Bacchus, 2001). Despite its near **dominance, its one achilles** heel remains generation of "parallel plans" (Haslum & Geffner, 2000). Parallel plans allow concurrent execution of multiple actions in each time step. **Such concurrency is likely** to be more important as we progress to temporal domains. While disjunctive planners such as Graphplan (Blum & Furst, 1997) SATPLAN (Kautz & Selman, 1996) and GPCSP (Do & Kambhampati, 2000) seem to have no trouble generating such parallel plans, planners that search in the space of states are overwhelmed by this task. The main reason is that straightforward methods for generation of parallel **plans would involve progression**
or regression over sets of actions. This increases the branching factor of the search space exponentially. Given n **actions, the branching factor of a simple progression or regression**
search is bounded by n**, while that of progression or regression search for parallel plans will**
be bounded by 2n.

The inability of state search planners in producing parallel plans has been noted in the literature previously. Past attempts to overcome this limitation have not been very successful. Indeed, Haslum and Geffner (2000) consider the problem of generating parallel plans using a regression search in the space of states. They note that the resulting planner, HSP*p, scales significantly worse than Graphplan. They **present TP4 in (Haslum &**
Geffner, 2001), which in addition to being aimed at actions with durations, also improves