Rather than doctor the existing branch, in the current implementation, we just add a new branch below Sx **that reflects the changes made by the** Pushup procedure.3 **The new**
branch then becomes the active search branch, and its leaf node is expanded next.

Aggressive Variation of Pushup: The Pushup **procedure, as described above, is not**
expensive as it only affects the current search branch, and the only operations involved are recomputing the regressions in the branch. Of course, it is possible to be more aggressive in manipulating the search branch. For example, after applying an action a **to its ancestor**
Sx the set of literals in the child state, say Snew **changes, and thus additional actions may** become relevant for expanding Snew. In principle, we could re-expand Snew **in light of the**
new information. We decided not to go with the re-expansion option, as it typically does not seem to be worth the cost. In Section 4.3, we do compare our **default version of** Pushup procedure with a variant that re-expands all nodes in the search branch, and the results of those studies support our decision to avoid re-expansion. Finally, although we introduced the Pushup **procedure as an add-on to the fattening step, it can also be used independent of**
the latter, in which case the net effect would be an incremental parallelization of a sequential plan.

Example: In Figure 8(a), we have two actions leading to the node Spar **(at depth two),**
these two actions are Unload(pack4,airp2,Home) and fly(airp1,LocX,ASU)**. So, before**
expanding Spar **we check if any of the two actions leading to it can be pushed up. While the**
second action is not pushable since it interacts with the actions in its ancestor node, the first one is. We find the highest ancestor in the partial plan that interacts with our pushable action. In our example the root node is such an ancestor. So, we insert our pushable action Unload(pack4,airp2,Home) **directly below the root node. We then re-adjust the**
state Spar to Snew **at depth 1, as shown in Figure 8(b), adding a new branch, and reflecting**
the changes in the states below. Notice that the action Unload(pack4,airp2,Home) was initially discarded by the greediness of the fattening procedure (see Figure 6), but we have offset this negative effect with our plan compression algorithm. We can see also that we have not re-expanded the state Snew **at depth 1, we have only made the adjustments to the**
partial plan using the actions already presented in the search trace.4

## 4. Evaluating The Performance Of Altaltp

We implemented AltAltp **on top of** AltAlt**. We have tested our implementation on a suite**
of problems that were used in the 2000 and 2002 AIPS competition (Bacchus, 2001; Long & Fox, 2002), as well as other benchmark problems (McDermott, 2000). Our experiments are broadly divided into three sets, each aimed at comparing **the performance of** AltAltp under different scenarios:
1. Comparing the performance of AltAltp**to other planning systems capable of producing**
parallel plans.