the branching scheme of HSP*p, by making it incremental along the lines of Graphplan.

Empirical studies reported by Haslum and Geffner (2001), however indicate that even this new approach, unfortunately, scales quite poorly compared **to Graphplan variants. Informally, this achilles heel of heuristic state search planners has been interpreted as a sort of**
last stand of the disjunctive planners - **only they are capable of generating parallel plans**
efficiently.

Given that the only way of efficiently generating optimal parallel plans involves using disjunctive planners, we might want to consider ways of generating near-optimal parallel plans using state search planners. One obvious approach is to post-process the sequential plans generated by the state search planners to make them parallel. While this can easily be done - using approaches such as those explored by Backstrom (1998), one drawback is that such approaches are limited to transforming the sequential plan given as input.

Parallelization of sequential plans often results in plans **that are not close to optimal parallel**
plans.1 An alternative, that we explore in this paper, involves incremental online parallelization.

Specifically, our planner AltAltp**, which is a variant of the** AltAlt **planner (Sanchez, Nguyen,**
& Kambhampati, 2000; Nguyen, Kambhampati, & Sanchez, 2002), starts its search in the space of regression over single actions. Once the most promising single action to regress is selected, AltAltp**then attempts to parallelize ("fatten") the selected search branch with**
other independent actions. This parallelization is done in **a greedy incremental fashion -**
actions are considered for addition to the current search branch based on the heuristic cost of the subgoals they promise to achieve. The parallelization continues to the next step only if the state resulting from the addition of the new action has a better heuristic cost. The sub-optimality introduced by the greedy nature of the parallelization is offset to some extent by a plan-compression procedure called Pushup **that tries to rearrange the evolving**
parallel plans by pushing up actions to higher levels in the search branch (i.e. later stages of execution) in the plan.

Despite the seeming simplicity of our approach, it has proven to be quite robust in practice. In fact, our experimental comparison with five competing planners - STAN (Long
& Fox, 1999), LPG (Gerevini & Serina, 2002), Blackbox (Kautz **& Selman, 1996), SAPA (Do**
& Kambhampati, 2001) and TP4 (Haslum & Geffner, 2001) - shows that AltAltp**is a viable**
and scalable alternative for generating parallel plans in several domains. For many problems, AltAltp**is able to generate parallel plans that are close to optimal in makespan. It also**
seems to retain the efficiency advantages of heuristic state search over disjunctive planners, producing plans in a fraction of the time taken by the disjunctive planners in many cases.

AltAltp **has also been found to be superior to post-processing approaches. Specifically,** we compared AltAltpto an approach that involves post-processing the sequential **plans** generated by AltAlt **using the techniques from Backstrom (1998). We found that** AltAltpis able to generate shorter parallel plans in many cases. Finally, we show that AltAltp**incurs**
very little additional overhead compared to AltAlt.

In the rest of this paper, we discuss the implementation and evaluation of our approach to generate parallel plans with AltAltp**. Section 2 starts by providing a review of the** AltAlt **planning system, on which** AltAltp**is based. Section 3 describes the generation of**