any element of S. The result of regressing S over a is then (S\eff(a)) ∪ prec(a**) - which is**
essentially the set of goals that still need to be achieved before the application of a**, such** that everything in S would have been achieved once a **is applied. For each relevant action** a, a separate search branch is generated, with the result of regressing S **over that action as**
the new fringe in that branch. Search terminates with success at a node if every literal in the state corresponding to that node is present in the initial state of the problem.

The crux of controlling the regression search involves providing a heuristic function that can estimate the relative goodness of the states on the fringe of the current search tree and guide the search in the most promising directions. The heuristic function needs to evaluate the cost of achieving the set S **of subgoals (comprising a regressed state) from the initial**
state. In other words, the heuristic computes the length of the plan needed to achieve the subgoals from the initial state. We now discuss how such a heuristic can be computed from the planning graph, which, provides optimistic reachability estimates.

Normally, the planning graph data structure supports "parallel" plans - i.e., plans where at each step more than one action may be executed simultaneously. Since we want the planning graph to provide heuristics to the regression search module of AltAlt**, which generates**
sequential solutions, we first make a modification to the algorithm so that it generates a
"serial planning graph." A serial planning graph **is a planning graph in which, in addition** to the normal mutex relations, every pair of non-noop actions **at the same level are marked**
mutex. These additional action mutexes propagate to give additional propositional mutexes. Finally, a planning graph is said to level off **when there is no change in the action,**
proposition and mutex lists between two consecutive levels.

We will assume for now that given a problem, the Graphplan module of AltAlt **is used**
to generate and expand a serial planning graph until it levels off. As discussed by Sanchez et al. (2000), we can relax the requirement of growing the planning graph to level-off, if we can tolerate a graded loss of informedness of heuristics derived from the planning graph. We will start with the notion of level of a set of propositions:
Definition 1 (Level) Given a set S of propositions, lev(S) **is the index of the first level**
in the leveled serial planning graph in which all propositions in S **appear and are non-mutex**
with one another. If S is a singleton, then lev(S) **is just the index of the first level where**
the singleton element occurs. If no such level exists, then lev(S) = ∞ **if the planning graph**
has been grown to level-off.

The intuition behind this definition is that the level of a literal p **in the serial planning**
graph provides a lower bound on the length of the plan (which, **for a serial planning graph,**
is equal to the number of actions in the plan) to achieve p **from the initial state. Using this**
insight, a simple way of estimating the cost of a set of subgoals will be to sum their levels.

## Heuristic 1 (Sum Heuristic) Hsum(S**) :=** Pp∈S Lev({P})

The sum heuristic is very similar to the greedy regression heuristic used in UNPOP (McDermott, 1999) and the heuristic used in the HSP planner (Bonet et al., 1997). Its main limitation is that the heuristic makes the implicit assumption that all the subgoals (elements of S) are independent. The hsum **heuristic is neither admissible nor particularly informed**
as it ignores the interactions between the subgoals. To develop more effective heuristics,