we need to consider both positive and negative interactions **among subgoals in a limited**
fashion.

In (Nguyen et al., 2002), we discuss a variety of ways of using **the planning graph to**
incorporate negative and positive interactions into the heuristic estimate, and discuss their relative tradeoffs. One of the best heuristics according to that analysis was a heuristic called hAdjSum2M **. We adopted this heuristic as the default heuristic in** AltAlt**. The basic idea** of hAdjSum2M **is to adjust the sum heuristic to take positive and negative interactions into**
account. This heuristic approximates the cost of achieving the subgoals in some set S **as the** sum of the cost of achieving S**, while considering positive interactions and ignoring negative**
interactions, plus a penalty for ignoring the negative interactions. The first component RP(S) can be computed as the length of a "relaxed plan" for supporting S**, which is**
extracted by ignoring all the mutex relations**. To approximate the penalty induced by the**
negative interactions alone, we proceed with the following **argument. Consider any pair of**
subgoals p, q ∈ S. If there are no negative interactions between p and q, then lev({**p, q**}), the level at which p and q are present together, is exactly the maximum of lev(p) and lev(q). The degree of negative interaction between p and q **can thus be quantified by:**

## Δ(P, Q) = Lev({P, Q}) − Max (Lev(P)**, Lev**(Q))

We now want to use the δ **- values to characterize the amount of negative interactions** present among the subgoals of a given set S. If all subgoals in S **are pair-wise independent,**
clearly, all δ values will be zero, otherwise each pair of subgoals in S **will have a different** value. The largest such δ value among any pair of subgoals in S **is used as a measure of the**
negative interactions present in S in the heuristic hAdjSum2M **. In summary, we have**

## Heuristic 2 (Adjusted 2M) Hadjsum2M (S) := Length(Rp(S)) + Maxp,Q∈Sδ(**P, Q**)

The analysis by Nguyen et al. (2002) shows that this is one of the more robust heuristics in terms of both solution time and quality. This is thus the default heuristic used in AltAlt
(as well as AltAltp**; see below).**

## 3. Generation Of Parallel Plans Using Altaltp

The obvious way to make AltAlt **produce parallel plans would involve regressing over subsets**
of (non interfering) actions. Unfortunately, this increases the branching factor exponentially and is infeasible in practice. Instead, AltAltp **uses a greedy depth-first approach that makes**
use of its heuristics to regress single actions, and incrementally parallelizes the partial plan at each step, rearranging the partial plan later if necessary.

The high level architecture of AltAltp**is shown in Figure 2. Notice that the heuristic**
extraction phase of AltAltp**is very similar to that of** AltAlt**, but with one important modification. In contrast to** AltAlt **which uses a "serial" planning graph as the basis for its**
heuristic (see Section 2), AltAltp **uses the standard "parallel" planning graph. This makes**
sense given that AltAltp**is interested in parallel plans while** AltAlt **was aimed at generating**
sequential plans. The regression state-search engine for AltAltp**is also different from the**
search module in AltAlt. AltAltp **augments the search engine of** AltAlt **with 1) a fattening**
step and 2) a plan compression procedure (Pushup**). The details of these procedures are**
discussed below.