actions in the relaxed plan achieving the preconditions that would become unsupported if a were removed from A, together with an estimation of the earliest time when all these preconditions would become supported.  The relaxed subplans used in EvalAdd( a ) and EvalDel(a) are computed by RelaxedPlan, as described in Section 3.2.1.

After having computed the state INIT t using Supported_facts ( l ), in step 2 EvalAdd uses RelaxedPlan to compute a relaxed subplan ( Rplan ) for achieving the preconditions of the new action a from INIT t . Steps 3–4 compute an estimation of the earliest time when a can be executed as the maximum value over the end times of all the actions preceding a in A (t 1 ) and End time(Rplan) (t 2 ). Steps 5–6 compute a relaxed plan for Threats(a) taking account of a and the actions in the first relaxed subplan.

EvalDel is simpler than EvalAdd, because the only new inconsistencies that can be generated by removing a are the precondition nodes supported by a (possibly through the no-op propagation of its effects) that would become unsupported. Unsup_facts (a) denotes the st of these nodes.

Of course, an action elimination from A to cope with an inconsistency could remove some additional inconsistencies (the unsupported preconditions of the eliminated action).

Similarly, an action that is added to A to support a certain precondition could support additional preconditions as well. However note that, as described in Section 3.1, Walkplan, like Walksat, does not consider possible improvements during the evaluation of the search nneeiiiibborhood. Hence, EvalDel and EvalAdd do not take account of additional inconsistencies that are removed from A as positive "side-effects" of coping with the inconsistency under cnsideration.

In order to illustrate the steps of EvalAdd, consider again the example of Figure 4. As shown in Section 3.2.2, the pair assigned to Rplan by step 2 of EvalAdd(a) is ({a1, a4, a5}, 240)
(which is the pair of values returned by Relaxed Plan( Pre(a), INITi, 0)). At step 3 of Eval-
Add(a) suppose that t 1 is set to 230 (i.e., that the highest temporal value assigned to the actions in the TA-graph that must precede a is 230).  Step 4 sets t 2 to MAX {230, 240}, and the execution of Relaxed Plan({q}, INIT i ={q}, {a1, a1, a5, a}) at step 6 returns ({a1, a1, a5, a7},
t g ), where t g is a temporal value that is ignored in the rest of the algorithm, because it does not affect the estimated end time of a. Thus, since the duration of a is 30, the output of EvalAdd(a) is ({a1, a1, a5, a, a7}, 240 + 30).

## 3.3  Computing Reachability And Temporal Information

The techniques described in the previous subsection for computing the action evaluation function use heuristic reachability information about the minimum number of actions required to achieve a fact f from INIT i ( Num acts ( f, l )), and the earliest times for actions and preconditions. LPG precomputes Num acts ( f, l ) for l = 1 and any fact f, i.e., it estimates the minimum number of actions required to achieve f from the initial state I of the planning problem before starting the search. For l > 1, Num acts ( f, l ) can be computed only during search because it depends on which actions nodes are in the current TA-graph
( at levels preceding l ). Since during search many action nodes can be added and removed, it is important that the computation of Num act s( f, l) is fast.

Figure 6 gives ComputeReachabilityInformation, the algorithm used by LPG for computing Num act s( f, 1) trying to take account of the tradeoff between quality of the estimation