Every time an action is added/removed to/from a level of A we apply/retract the numerical effects of the action, which can modify the values associated with some numerical fact nodes at the next level. These changes are propagated to the following levels of the graph.

During this propagation, we identify the numerical preconditions that become supported or unsupported. Moreover, if the value of a numerical fact node affecting the duration of an action is changed, then we update the duration of this action.

The local search neighborhood associated with an unsupported numerical precondition p = (exp,rel, exp') of an action a is defined as the set of linear action graphs obtained by either removing a , or adding a new action that decreases the "gap" between the values of exp and exp ′ according to rel (possibly supporting p ). 20  In the competition version of LPG,
we considered adding an action only to the level immediately before the level of p (while for a boolean unsupported precondition q an action supporting it can be added to any preceding level).  We are currently studying an extension of the neighborhood in which supporting actions can be added to any preceding level also in the case of numerical preconditions.

We now briefly describe how LPG computes the relaxed plans used by EvalAdd and EvalDel for numerical domains. This is done by an extended version of RelaxedPlan handling numerical preconditions in a very simple way. Since the current version of ComputeReachabilityInformation ignores numerical preconditions, there is no Num acts -value associated with them. Hence, when RelaxedPlan chooses the (heuristic) best action to support a subgoal g , for each numerical precondition p involved in the definition of Bestaction(g) (see Section 3.2.1), N um acts ( p, l ) is replaced by 1, i.e., the estimated minimum cost to satisfy any numerical precondition is always 1. (Of course, this is quite a strong assumption giving weak information; we are currently working on a new version of the planner using more informative heuristics for constructing relaxed plans involving numerical preconditions.)
Another difference in the definition of Bestaction (g) is that, if g is a numerical precondition, instead of considering only the actions supporting g, we consider every action that decreases the gap between the values of the expressions forming g.

The relaxation of the plans computed by the extended version of RelaxedPlan concerns both the negative effects, which are ignored for plan validity (but considered to count possible threats), and a form of monotonic change of the minimum and maximum possible values for the numerical quantities. We start from the numerical initial state INIT 1 =
( Supported_facts (l), Num_values (l)) and, for each numerical variable involved in an action in the relaxed plan constructed from INIT t , we consider only the minimum/maximum values that the variable can assume given the actions already in the relaxed plan. These values are monotonically decreased/increased whenever an action is added to the relaxed plan. Specifically, we define two tuples of numerical values, vmax and vmin, that are both initialized using Num values ( l ). If an effect of an action in the relaxed plan increases the value of a variable v i by a quantity δ , then we increase v imax by δ ; while, if it decreases the value of v i by δ , then we decrease v in by δ . During the construction of a relaxed plan, when we check whether a numerical precondition p = ( v x , >, v y ) is supported, we evaluate vx > vv considering vx as the value assigned to vx, and vmin as the value assigned to