level containing action nodes. An action node at a level t represents an action (instantiated operator) that can be planned at time step t. A fact node at a level trepresents a proposition corresponding to a precondition of one or more actions at time step t, or to an effect of one or more actions at time step t - 1. The fact nodes of level 1 represent the positive facts of the initial state of the planning problem (every fact that is not mentioned in the initial state is considered false).

In the following, we indicate with [ u ] the proposition (action) represented by the fact node (action node) u. The edges in a planning graph connect action nodes and fact nodes.

In particular, an action node a at a level i is connected by: precondition edges from the fact nodes of level i representing the preconditions of [ a ]; add-edges to the fact nodes of level i + 1 representing the positive effects of [a]; delete-edges to the fact nodes of level i + 1 representing the negative effects of [ a ]. Ea fact node f at a level l is associated with a no-op action node at the same level, which represents a dummy action having [ f ] as its only precondition and effect.

Two action nodes a and b are marked as mutually exclusive in the graph when one of the actions deletes a precondition of the other ( interference ) or an add-effect of the other
( inconsistent effects ), or when a precondition node of a and a precondition node of b are marked as mutually exclusive ( competing needs ).

Two proposition nodes p and q in a proposition level are marked as exclusive if all ways of making proposition [ p ] true are exclusive with all ways of making [ q ] true (each action node a having an add-edge to p is marked as exclusive with each action node b having an add-edge to q ). When two fact or action nodes are marked as mutually exclusive, we say that there is a mutex relation (or simply a mutex) between them.

Given a planning problem Π, the corresponding planning graph G can be incrementally constructed level by level starting from level 1 using a polynomial algorithm (Blum & Furst, 1997). The graph construction should reach a propositional level where the goal nodes are present, and there is no mutex relation between them. 1 The fixed-point level of the graph is the level from which the nodes and mutex relations at every subsequent level remain the same. Blum and Furst refer to this level as the level where the graph has "leveled off".

The mutex relations in the planning graph monotonically decrease with the increase of the levels: a mutex relation holding at a certain level may not hold at the next levels, but it is guaranteed that it holds at all previous levels containing the fact/action nodes involved in the relation. The mutex relations at the fixed-point level of the graph are called persistent mutex relations (Fox & Long, 2000), because they hold at every level of the graph.

Without loss of generality, we can assume that the goal nodes of the last level represent the preconditions of the special action [ aena ], which is the last action in any valid plan, while the fact nodes of the first level represent the effects of the special action [ astart ], which is the first action in any valid plan.

Our approach to planning uses particular subgraphs of G, called action graphs, which represent partial plans. Definition 1 An action graph (A-graph) for G is a subgraph A of G containing astart and aena, and such that, if a is an action node of G in A, then also the fact nodes of G