v . If an expression involves more than one numerical variable (e.g., p = ( v x − v y , >, v x )),
we consider the combination of the maximum/minimum values that is most favorable to satisfy the condition (the value of vx is vmax, the value of vy is vynin, and the value of vz is v min ). Similarly if the expression involves another relational operator.

## 3.6  Multi-Criteria Incremental Plan Quality

As we have seen, our approach can model different plan quality criteria determined by action execution costs and action durations. The coefficients α, β and γ of the action evaluation function E specified in Section 3.2 are used to weigh the relative importance of the execution and temporal costs of E, as well as to normalize them with respect to the sseerch cost. Specifically, LPG uses the following function for evaluating the insertion of an action node a (the evaluation function E ( a ) r for removing an action node is analogous):

$$E(a)^{i}={\frac{\mu_{E}}{m a x_{E T}}}\,E x e c u t i o n_{e}o s t(a)^{i}+{\frac{\mu_{T}}{m a x_{E T}}}\,T e m p o r a l_{e}o s t(a)^{i}+{\frac{1}{m a x_{S}}}\,S a r e h_{e}o s t(a)^{i},$$

where µ E and µ T are non-negative coefficients that weigh the relative importance of the execution and temporal costs, respectively. Their values can be set by the user, or they can be automatically derived from the expression defining the plan metrics in the formalization of the problem. The factors 1/maxET and 1/maxS are used to normalize the terms of E to a value less than or equal to 1. The value of maxET is defined as µE · maxE + µT · maxT ,
where maxe (maxt) is the maximum value of the first (second) term of E over all TA-
graphs in the neighborhood, multiplied by the number κ of inconsistencies in the current action graph; maxs is defined as the maximum value of Search cost over all possible action insertions/removals that eliminate the inconsistency under consideration.  The role of κ is to decrease the importance of the first two optimization terms when the current plan contains many inconsistencies, and to increase it when the search approaches a valid plan. I.e., E(a) f cn be rewritten as

$E(a)^{i}=\frac{1}{\kappa\cdot(\,\mu_{E}\cdot\max_{E}+\mu_{T}\cdot\max_{T})}\cdot(\,\mu_{E}\cdot\,Execution\_cost(a)^{i}+\mu_{T}\cdot\,Temporal\_cost(a)^{i})\,+\,+\,\frac{1}{\max_{S}}\cdot\,Search\_cost(a)^{i}$.  
Without this normalization the first two terms of E could be much higher than the value of the third term. This would guide the search towards good quality plans without paying sufficient attention to their validity. Instead, we would like to have the search give more importance to reducing the search cost, rather than optimizing the quality of a plan, especially when the current partial plan contains many inconsistencies, Our planner can produce a succession of valid plans where each plan is an improvement of the previous ones in terms of quality. The first plan generated is used to initialize a new search for a second plan with better quality, and so on. This is a process that incrementally improves the quality of the plans, and the search can be stopped at any time to give the best plan computed so far (each plan can be written in a file as soon as it is derived). When LPG starts a new search, some inconsistencies are forced in the TA-graph representing the previous plan, and the resulting TA-graph is used to initialize the search. Similarly, during search some random inconsistencies are forced in the current TA-graph when a valid plan that does not improve the plan of the previous search is reached. This is done by choosing