We ran LPG with the same default settings for every problem attempted (maximum nmbers of search steps and restarts for each run, inconsistency selection strategy, and noise factor), that can be modified by the user. The default initial value of the noise p is 0.1. Note that this is a dynamic value that is automatically increased/decreased by the planner during search, depending on the variance of the number of inconsistencies in the last n search steps. In all our tests p was automatically increased if the variance did not change significantly in the last 50 search steps. It was set to the initial default value otherwise.

The parameters µE and µT of the action evaluation function were automatically set using the (linear) plan metric specified in the problem formalization. In particular, µ E was set to 1, while p T was set to the coefficient weighing the total-time variable in the expression specifying the plan metric. For instance, in the example of plan metric given at the end of Section 2, the coefficient weighing total-time is 4, and so for that problem µ T was set to 4. If no plan metric was specified, then µ E was set to 0.5 and µ T to 0.

The performance of LPG was tested in terms of both CPU-time required to find a solution ( LPG -speed) and quality of the best plan computed ( LPG -quality) using at most five CPU-minutes. In the plots of Figures 9, 10, 11 and 12, on the x-axis we have the problem nmes (simplified with numbers); on the y-axis, in the plots for CPU-time we have milliseconds (logarithmic scale), while in the plots for plan quality we have the quality of the plans generated, measured using the plan metric expression in the corresponding problem specification. Note that the lower the plan quality values, the better the corresponding plans are.

Figure 9 shows the performance of LPG-speed compared to the other competitors in some variants of four domains. 24 In DriverLog Strips, FF is on average the fastest planner, but LPG solves more problems, and it scales up somewhat better. In ZenoTravel SimpleTime, LPG outperforms the other competitors in terms of both number of problems solved and CPU-time (our planner is about one order of magnitude faster). In Satellite Complex the excellent performance of LPG is even more evident especially for the largest problems. Finally, in Rovers Numeric, FF and LPG perform similarly, but our planner solves a larger nmber of problems. The plots concerning the performance of LPG-quality for these four domain variants are given in Figure 10. These results show that the solution computed by our planner was always similar to or better than the solution derived by any of the other planners. The most interesting differences are in Satellite Complex, where LPG-quality produced solutions of higher quality for almost every problem.

In order to derive some general results about the performance of our approach with respect to all other fully-automated planners of the competition, we compared LPG with the best result over all these planners. We will indicate these results as if they were produced by a hypothetical "SuperPlanner" (which does not exist).  Clearly, if LPG performs generally better than the SuperPlanner in a certain domain, then in that domain it performs better than any other real planner that we considered. On the other hand, if it performs worse,