
## Appendix A: Mutex Relations In Lpg And Related Work

LPG precomputes a set of mutex relations for the input planning problem using the two algorithms given in Figure 15, where Add ( a ) denotes the set of the positive effects of a, Del ( a )
the set of its negative effects, and Pre(a) the set of its preconditions. ComputeMutexFacts derives a set of mutex relations between facts, that are used by ComputeMutexActions to compute a set of relations between actions. The correctness of this second algorithm is obvious since it just applies the original definition of mutex relation (Blum & Furst, 1997).

ComputeMutexFacts iteratively constructs a set M of potential mutex relations and the set F of all possible facts for the planning problem under consideration. At each iteration we consider every possible action a (step 5) to possibly generate a set of new potential mutex relations (steps 7–11), and to possibly invalidate other potential mutex relations that have aready been formulated (steps 12–18). The algorithm terminates when all possible facts have been considered ( F* = F ), and no new potential mutex relations can be generated ( M* = M ). When the algorithm terminates, M contains a set of persistent mutex relations between facts. A mutex relation m in M is persistent if there is no state that can be reached from the initial state of the problem, using the operators of the domain under consideration, in which the facts of m are both true. All mutex relations in the fixed-point level of a traditional planning graph are persistent.

Given an action a, two facts fi and f 2 form a potential mutex relation m if (1) one of them is a positive effect of a and the other is a negative effect (steps 7–9), or (2) one of them is a positive effect of a and the other is (potentially) mutually exclusive with a precondition of a (steps 7, 10 and 11). (1) is a natural way of hypothesizing mutex relations that is used also by Gerevini and Schubert (1998). (2) is based on the observation that, if fi is an effect of a, p E Pre(a), f2 & Add(a), and f2 is mutually exclusive with p, then in any state resulting from the application of a to a reachable state, f 2 and f 1 cannot be both true.

A potential mutex relation m ∈ M between f 1 and f 2 becomes invalid if (1) there exists an action containing the two facts of m among its positive effects (steps 13–14), or fi ( f2 ) is an add-effect of an action a, f 2 ( f 1 ) is not deleted by a, and f 2 ( f 1 ) is (potentially) mutually exclusive with no precondition of a (steps 15–18).  The first case if obvious, while the second can be explained as follows. If fi is a positive effect of a, and we cannot exclude that f2 is true in a state where a can be applied, then f 2 could persist from this state to the state produced by a (similarly if f 2 is a positive effect of a ).

Note that LPG handles negative preconditions as proposed by Koehler et al. (1997), i.e.,
no explicit atomic negation is available in LPG 's language. Instead we model atomic negation by introducing an additional predicate not-p ( x ) if ¬p ( x ) is needed and by formulating add and delete effects correspondingly ( this guarantees than not-p ( x ) and p ( x ) are mutex).

The next theorem states the correctness of our algorithms.

Theorem ComputeMutexFacts and ComputeMutexActions correctly compute a set of persistent mutex relations between facts and actions respectively.

Proof.  Correctness of ComputeMutexActions is obvious, since it is a direct consequence of the definition of persistent mutex relation between actions. Correctness of ComputeMutexFacts follows from the two conditions under which a potential mutex relation is made