# Talplanner In The Third International Planning Competition: Extensions And Control Rules

Jonas Kvarnstr¨om jonkv@ida.liu.se Martin Magnusson marma@ida.liu.se Department of Computer and Information Science Link¨oping University SE-581 83 Link¨oping, Sweden

## Abstract

TALplanner is a forward-chaining planner that relies on domain knowledge in the shape of temporal logic formulas in order to prune irrelevant parts of the search space. TALplanner recently participated in the third International Planning Competition, which had a clear emphasis on increasing the complexity of the problem domains being used as benchmark tests and the expressivity required to represent these **domains in a planning system.**
Like many other planners, TALplanner had support for some but not all aspects of this increase in expressivity, and a number of changes to the planner were required. After a short introduction to TALplanner, this article describes some of **the changes that were made** before and during the competition. We also describe the process of introducing suitable domain knowledge for several of the competition domains.

## 1. Introduction

Like most planners, TALplanner (Kvarnstr¨om & Doherty, 2000; Doherty & Kvarnstr¨om, 1999; Kvarnstr¨om, Doherty, & Haslum, 2000; Doherty & Kvarnstr¨om, 2001; Kvarnstr¨om & Doherty, 2003; Kvarnstr¨om, 2002) allows the user to specify a goal in the shape of a set of atemporal logic formulas that must be satisfied in the final state that results from executing a plan. Unlike most planners TALplanner also allows the specification of a set of **temporal** logic formulas that must be satisfied by the entire state sequence **generated by a plan.**
Obviously, these formulas can be used to specify temporally **extended goals, such as**
safety and maintenance goals that must be upheld throughout **the execution of a plan.**
However, it is also possible to specify constraints related **to traditional measures of plan** quality, such as constraints that forbid certain "stupid" actions from taking place, as in the Blockhead blocks world planner by Kibler and Morris (1981) or TLplan **by Bacchus and**
Kabanza (2000), which initially inspired the development of TALplanner. For example, in a logistics domain one may specify a temporally extended goal stating that once a package is at its destination, it is never picked up again, and a goal stating that trucks driving between two locations always use the shortest path. Such constraints can then be processed by TALplanner in order to automatically extract control knowledge that can be used during a forward-chaining search process, as opposed to being used **as a filter after a candidate plan** has been generated. Given sufficiently strong constraints, the planner can efficiently prune most of the search tree, making it easier to find a plan among the remaining nodes. Often (as in this article) the search control aspect is in fact the primary reason for introducing a temporally extended goal, in which case the goal is usually referred to as a control rule.