
## 4.5 Non-Integer Time

Some of the IPC-2002 contest domains required operator durations to be calculated with a precision of at least three decimals, which posed a problem for us. The underlying TAL-C logic is based on integer time, and therefore the same is true **for TALplanner. Introducing** non-integer time properly would have required changes to the underlying TAL semantics, which could not be done in the time that was available, and therefore we simply multiplied durations by a thousand. When printing a plan, all time values were divided by a thousand.

## 4.6 Operators With Extended Duration

In the initial implementation of TALplanner (in 1998–1999), it was assumed that although operators might have extended durations, something interesting would be happening at a significant proportion of the discrete time steps within that duration. For example, an operator invoked at t **might have a duration of 5 time steps, where some effects take place**
at time t + 1, some at time t + 4, and some at time t **+ 5. This assumption influenced some**
of the algorithms and data structures in TALplanner, and appeared reasonable at the time, since most planning domains in the literature only used single-step operators.

Nevertheless, it was always our intention to extend these algorithms and structures to handling plans with sparse effects, where most discrete time **steps contain no effects at all.**
Doing this would not have been difficult, but partly for that very reason - there were more interesting research issues to be tackled instead - it was continuously postponed.

IPC-2002 finally provided us with a compelling reason to change the data structures, together with a number of example domains that could be used to test the changes. For example, an operator in a timed domain from IPC-2002 might have a duration of (say)
89.237, requiring 89237 discrete time steps, where all effects take place at the beginning or at the end of the action. This led us to implement a new sparse state structure and change a few algorithms whose time complexity accidentally **depended on the duration of**
an operator rather than the number of time steps where something actually happened. The current version of TALplanner allows both state structures **to be used depending on the**
characteristics of each planning domain.

## 4.7 The "No Moving Targets" Rule

As already mentioned, TALplanner's semantics is based on the use of TAL, while the planning competition uses PDDL2.1. While the semantic differences between these two approaches are usually not a major problem, we did have some trouble with the way the effects of durative actions are modeled in PDDL2.1. In essence, PDDL2.1 predicates or numerical fluents that are affected by the effects of an action are considered to be "moving targets", and the preconditions of another action are not allowed to refer to them at the same timepoint. Instead, a certain intermediate interval (arbitrarily chosen to be 0.001 units of time) is required between the assertion of a fact and **the subsequent use of that** fact, even at the beginning of the plan where actions cannot begin exactly at time 0. In TAL, effects taking place at time t **are assumed to give fluents their new values exactly at**
that timepoint, and those values can immediately be used. If **there is some uncertainty in** the exact time when the effect takes place, one can for example **explicitly state that the**