value is unknown during the inner part of a certain interval but is known at the end of that interval (though this is not yet implemented in TALplanner).

Changing TALplanner to use the exact PDDL2.1 semantics was out of the question, since this would change some of the most fundamental assumptions in the planner. Instead it was necessary to come up with a workaround that let us simulate this semantics. There are several ways this could be done. One method would involve **making minor changes to**
the action definitions in order to assert the final effects of each action slightly later (0.001 units of time later, to be exact). During the competition we instead implemented a trivial modification to the way a plan is printed: At any timepoint where something happens in the plan (for example, where an operator is invoked), an additional delay of 0.**001 is inserted.**
This ensures that all plans are safe according to PDDL2.1 semantics but sometimes leads to generating slightly worse plans than necessary.

## 4.8 Finding Shortest Paths

In the Rover and DriverLog domains, vehicles and/or people must travel along road networks, where different roads may have different costs (lengths) and where it is essential to take the shortest path between any two points.

Although it is possible to define a shortest path algorithm using TALplanner's input language, the formulas become somewhat complicated. Finding the shortest path between two locations in a weighted graph of places and roads seems to **be useful in many domains,**
and therefore such an algorithm was implemented directly in **the planner.**
In fact, two algorithms were implemented: One for finding the **cost of the shortest**
path between two given locations, and one for finding the distance to the closest location satisfying a given formula (for example the closest location which is a reasonable destination for a certain truck in the DriverLog domain). These functions can be called from control rules in order to ensure that each step one takes leads to a location which is on some shortest path to the current destination.

## 5. Modeling The Competition Domains

Of the eight planning domains in the third International Planning Competition, six were intended for hand-tailored planners. Except for the final domain, UMTranslog-2, all domains exist in at least four different variations: STRIPS, Numeric **(where numeric quantities are** involved), SimpleTime (where operators take constant non-unit time), and Timed (where operator durations may depend on the actual parameters in a specific operator invocation).

TALplanner participated in all six domains, but due to lack of time for creating control rules, we limited our participation to the STRIPS, SimpleTime, and Timed versions of the domains.

In this section we will describe how the domains were translated from PDDL2.1 to TALplanner, and discuss some of the control rules that were created to handle the domains more efficiently. The main focus will be on two domains: ZenoTravel and Satellite. For these domains we will describe most of the control rules that were used in the competition as well as the incremental process of creating the rules, omitting only a few technical details and a couple of complex rules that turned out to have minimal impact on planner performance and plan quality. For the remaining domains (Depots, DriverLog, Rovers, and UMTranslog-2)