we will describe the general intuitions behind our control rules, omitting the actual formulas due to space restrictions. First, though, we will begin with **a few comments on the process**
of formalizing planning domains.

## 5.1 Using Pre-Defined Pddl Domains: Half The Work In Twice The **Time?**

In order to create a formal description of a real-world planning domain, it is of course always necessary to have a thorough understanding both of the domain itself and of how plans for the domain are eventually going to be used. There are several **reasons why this is required,** and most of these reasons are equally valid regardless of whether the formalization will eventually be used as the input to a fully automated planner or to a hand-tailored planner like TALplanner.

First, understanding the domain is required in order to determine what aspects of the domain truly need to be modeled (as types, predicates and functions) and what aspects can be abstracted away. For example, the standard formalization of the logistics domain does not model distances between locations, but allows trucks to move between any two locations in one time step. This is sufficient for some purposes, but a plan that is optimal given this abstraction may be extremely suboptimal if actually carried out by real trucks, which usually lack teleportation abilities. Similarly, it **does not model package sizes or** weights, or cargo capacities for trucks or airplanes. Neither does it model truck drivers, acceptable working hours for drivers, the additional costs **incurred by overtime pay, or time**
required for maintenance activities such as changing to winter tires once a year. Which of these aspects need to be modeled depends very much on the particular application one has in mind.

Second, a detailed understanding of the domain is required in order to determine what operators are available to the planner and exactly how their **preconditions and effects should** be represented within the abstract logical model of the domain.

And finally, for hand-tailored planners, the domain must be understood in order to be able to guide a search algorithm using domain-dependent heuristics or control rules.

Usually all of these aspects of a domain are modeled at the same time, and much of the information and knowledge about the domain that was gathered in order to find a suitable set of predicates and operators - which is needed even for a fully automated planner - can be reused in the development of control rules or heuristics for a hand-tailored planner.

In the planning competition, however, the task is divided into two parts: The organizers define a set of domains using PDDL2.1, and then it is up to the competitors in the handtailored track to find suitable ways of guiding their planners. In one way, one could say that the competitors only need to do half the work, since the formalization is already done and only the task of finding control rules remains. Unfortunately it is still necessary to understand the domain just as thoroughly in order to write control rules. For the more complex domains, doing this half of the work in isolation might easily take twice the time, since all the constraints involved in the domain have to be understood from a PDDL2.1 formalization rather than by talking to domain experts. This is especially true for the complex UMTranslog-2 logistics domain, where a significant **amount of time was spent** trying to determine exactly how packages were allowed to move and how they can be loaded into and unloaded from various kinds of vehicle.