

![0_image_0.png](0_image_0.png)

Another problem caused by having to use a predefined formalization of a planning domain is that the degree of detail used in the model is determined in advance. In the real world there would more likely be a minimum **level of detail required, and anything above**
this level would be acceptable. It may not seem like this should be a problem - intuitively, adding new details to a planning problem ought to make it harder, and so it would be best to remain at the minimum level of detail. But this is not always true, especially not when control rules are involved. This will be seen in the timed ZenoTravel domain, for example, where some control rules would be both simpler and more effective if it was possible to refuel to a specific level, just like in the real world, rather than just having a simple abstract refuel operator that unconditionally fills the tank completely.

This should not be taken as a complaint against the organization of the competition
- allowing different planners to use different formalizations would of course be completely infeasible. Nevertheless, it does present some additional **problems that are not encountered** to the same degree in real-world domains and that deserve to be mentioned here.

## 5.2 The Zenotravel Domain

In the ZenoTravel domain, there are a number of aircraft that **can fly people between cities.** There are five actions available: Persons may board and debark **aircraft, and aircraft may** fly, zoom **(fly quickly, using more fuel), and** refuel**. There are no restrictions on how many people**
an aircraft can carry. Flying and zooming are equivalent except that zooming is generally faster and uses more fuel. Figure 3 shows an example problem, **with arrows pointing out**
goal locations.

## 5.2.1 Zenotravel: Strips

Below we show the operator definitions for the STRIPS version **of the ZenoTravel domain.** These operators have been more or less directly translated from the PDDL representation.

The main difference is that the PDDL representation uses PDDL2.1 level 1, with singlestep actions, which has a stricter concept of mutual exclusion than TALplanner does and