board an aircraft, which gives rise to the following control **rule:**

#control :name "**only-board-when-necessary**" [t] ¬in(person, aircraft) ∧ [t+1] in(person, aircraft) → ∃city, city2 [ [t] at(person, city) ∧ goal(at(person, city2)) ∧ city 6= city2 ]
This TAL formula states that if we have a state transition from the person not being in the aircraft at time t to the person being in the aircraft at time t**+ 1, (that is, if the person just**
boarded the aircraft), then there must be a reason why this is **allowed: The person must** be in a certain city and there must be a goal that the person should be in another city.

As noted previously control formulas can usually be written **in many different forms.**
For example, it would have been equally valid to state that if **a person is at a city (and** therefore not in an aircraft), and is not required to be somewhere else, then at the next timepoint that person should still not be on board an aircraft:

#control :name "**only-board-when-necessary**" [t] at(person, city) **∧ ¬∃**city2 [ goal(at(person, city2)) ∧ city 6= city2 ] → [t+1] ¬in(person, aircraft)
Note that although it may at first glance appear that a planner **would have to be extraordinarily stupid to destroy goals that have already been satisfied, there are also many cases**
where temporarily destroying a goal is necessary in order to **satisfy other goals. For example, if there is a goal that a certain aircraft should be at a certain location and it has already**
reached that destination, it might still have to fly a number of people to their destinations before it can return to its own destination.

Another natural idea (since aircraft do not follow predetermined routes in ZenoTravel, as they usually do in real life) would be to say that people should only debark when they have reached their final destination:

#control :name "**only-debark-when-in-goal-city**" [t] in(person, aircraft) ∧ [t+1] ¬in(person, aircraft) → ∃city [ [t] at(aircraft, city) ∧ goal(at(person, city)) ]
There is a potential problem with this rule: In some cases an optimal plan might require a number of people to debark one plane and then board a number of **other planes, which could**
fly them to their destination concurrently, and this is strictly forbidden by only-debark-whenin-goal-city**. This is a common problem that occurs for many planning domains, and it is**
up to the user to determine what to do depending on the requirements of the application for which the planner is being used.

There are a number of possible choices: We could ignore this problem and accept suboptimal plans, skip the rule completely and let the planner search through a vastly greater search space in order to find a plan which is guaranteed to be optimal, or as a compromise, attempt to create a weaker rule that does cut down the search space to some degree but gives optimal or closer-to-optimal plans. During the planning competition the conditions were somewhat artificial and were not clearly stated - would it be beneficial for a planner to spend ten times as much effort finding a plan if this plan was only five percent better, on average? We guessed that this would not be the case, and consequently we chose to include the control rule as stated above.