In the future, a better solution would most likely be to prefer **those plans where a person**
does not debark before reaching his destination but still allow **other plans. This alternative**
will be discussed in more detail in the conclusions.

Given these two rules, we might now continue with the second approach to finding control rules. We run TALplanner on a simple problem instance and consider the operator sequences the planner examines during the depth-first search process. This is the beginning of such a sequence for the problem instance in Figure 3. The complete plan generated by the planner contains 123 operators and requires 60 time steps. It is shown here in the IPC-2002 STRIPS result format where the timepoint at which an action is invoked is followed by the action instance.

0: (board person4 plane2 city1) 0: (board person5 plane1 city2) 1: (fly plane1 city2 city0 fl5 fl4) 1: (fly plane2 city1 city0 fl3 fl2) 2: (board person1 plane1 city0) 2: (board person2 plane2 city0) 3: (fly plane1 city0 city1 fl4 fl3) 3: (fly plane2 city0 city1 fl2 fl1)

4: (debark person2 plane2 city1) 4: (debark person5 plane1 city1) 5: (fly plane1 city1 city0 fl3 fl2) 5: (fly plane2 city1 city0 fl1 fl0) 6: (fly plane1 city0 city1 fl2 fl1) 6: (refuel plane2 city0 fl0 fl1) 7: (fly plane1 city1 city0 fl1 fl0) 7: (fly plane2 city0 city1 fl1 fl0)
8: (refuel plane1 city0 fl0 fl1) 8: (refuel plane2 city1 fl0 fl1) 9: (fly plane1 city0 city1 fl1 fl0) 9: (fly plane2 city1 city0 fl1 fl0) 10: (refuel plane1 city1 fl0 fl1) 11: (fly plane1 city1 city0 fl1 fl0) 11 : (refuel plane2 city0 fl0 fl1) . . .
The beginning of the operator sequence appears to be reasonable, but after time 4, airplanes seem to be flying around randomly. There are no control rules guiding them, so apparently it was mainly luck that caused the planes to find reasonable cities to fly to at time 1 and 3.

To make airplanes more goal-directed, we identify three important reasons why an airplane should move from city to city2**: that the goal asserts that the aircraft must end up in** city2 when the plan is complete, that one of its passengers wants to **go to** city2**, or that there is a**
person waiting to be picked up by an airplane in city2**. The following rule formalizes these** three intuitions: \#control :name "**planes-always-fly-to-goal**"
[t] at(aircraft, city) ∧ [t+1] ¬at(aircraft, city) →
∃city2 [ [t+1] at(aircraft, city2) ∧
(goal(at(aircraft, city2)) ∨
∃person [ [t] in(person, aircraft) ∧ goal(at(person, city2)) ] ∨
∃person [ [t] at(person, city2) ∧ goal(¬at(person, city2)) ]) ]
With these control rules, TALplanner can quickly produce a set of plans for the 20 "handcoded" problems from the IPC-2002 competition, and although the plans will not be optimal, they will not be nearly as bad as the example given above. **Together, the plans require**
a total of 7164 operators and 618 time steps. The plan for the example in Figure 3 requires 20 operators and 7 time steps.

Nevertheless, there are still some improvements that can be **made. The first criterion**
is too admissible: It allows a plane to visit its destination **even if it still needs to pick up** or drop off passengers. One way of preventing this would be to add the condition that all passengers must have reached their destinations: \#define [t] **all-persons-arrived**:
∀person, city [ goal(at(person, city)) → [t] at(person, city) ]