\#control :name "**planes-always-fly-to-goal**"
[t] at(aircraft, city) ∧ [t+1] ¬at(aircraft, city) →
∃city2 [ [t+1] at(aircraft, city2) ∧
(**[t] all-persons-arrived** ∧ goal(at(aircraft, city2)) ∨
∃person [ [t] in(person, aircraft) ∧ goal(at(person, city2)) ] ∨
∃person [ [t] at(person, city2) ∧ goal(¬at(person, city2)) ]) ]
This improves plan quality slightly, and TALplanner now requires 7006 operators and 575 time steps. But the new control rule is in fact too strict, which can be seen in the following plan tail for handcoded STRIPS problem number 3:
14: (fly plane2 city4 city7 fl2 fl1) 14: (fly plane4 city8 city9 fl3 fl2)
14: (refuel plane1 city6 fl2 fl3)
14: (refuel plane3 city9 fl4 fl5) 15: (debark person24 plane4 city9) 15: (debark person28 plane4 city9) 15: (debark person34 plane2 city7)
15: (refuel plane1 city6 fl3 fl4) 15: (refuel plane2 city7 fl1 fl2)
15: (refuel plane3 city9 fl5 fl6)
15: (refuel plane4 city9 fl2 fl3) 16: (fly plane1 city6 city8 fl4 fl3) 16: (fly plane3 city9 city4 fl6 fl5)
In this example, plane1 and plane3 **had to wait until all passengers had debarked from**
several other planes until they could go to their final destinations, even though we can clearly see that there was no real reason for them to wait, because all potential passengers had already been picked up and plane1 and plane3 **already had enough fuel. We once again** alter the control rule according to this new insight: A plane **can go to its final destination** if all passengers on board the plane are headed towards the same destination and there is no person left to be picked up (that is, all persons have already arrived or are currently on board planes).

\#define [t] **all-persons-arrived-or-in-planes**:
∀person, city [ goal(at(person, city)) → [t] at(person, city) ∨ ∃aircraft [ in(person, aircraft) ] ]
\#control :name "**planes-always-fly-to-goal**"
[t] at(aircraft, city) ∧ [t+1] ¬at(aircraft, city) →
[t+1] at(aircraft, city2) ∧
((goal(at(aircraft, city2)) ∧ **[t] all-persons-arrived-or-in-planes** ∧
∀person [ [t] in(person, aircraft) → **goal(at(person, city2)) ]**) ∨
∃person [ [t] in(person, aircraft) ∧ goal(at(person, city2)) ] ∨
∃person [ [t] at(person, city2) ∧ goal(¬at(person, city2)) ])]
This yields another minor improvement, and TALplanner now requires 6918 operators and 564 time steps. For the example used above, the end of the plan **now looks as follows:**
14: (fly plane1 city6 city8 fl2 fl1) 14: (fly plane2 city4 city7 fl2 fl1)
14: (fly plane4 city8 city9 fl3 fl2) 14: (refuel plane3 city9 fl4 fl5)
15: (debark person24 plane4 city9) 15: (debark person28 plane4 city9)
15: (debark person34 plane2 city7) 15: (fly plane3 city9 city4 fl5 fl4)
We once more study the plans generated by the current set of rules and quickly identify another obvious problem: Any number of airplanes may fly to the same location to pick up the same person. Once again, it is necessary to find a reasonable balance between finding optimal plans and finding plans quickly. In the contest, we attempted to find a high quality