(but probably non-optimal) plan as quickly as possible. This was done by ensuring that no more than one airplane may go to any given place at the same time, if **the sole purpose for**
going there is to pick up a person who is waiting:
\#control :name "**planes-always-fly-to-goal**"
[t] at(aircraft, city) ∧ [t+1] ¬at(aircraft, city) → ∃city2 [ [t+1] at(aircraft, city2) ∧
((goal(at(aircraft, city2)) ∧ [t] all-persons-arrived-or-in-planes ∧
∀person [ [t] in(person, aircraft) → goal(at(person, city2)) ]) ∨
∃person [ [t] in(person, aircraft) ∧ goal(at(person, city2)) ] ∨
∃person [ [t] at(person, city2) ∧ goal(¬at(person, city2)) ] ∧
¬∃aircraft2 [ [t+1] at(aircraft2, city2) ∧ aircraft2 6= **aircraft ]**)]
This rule provides a major improvement, and the complete set **of plans now requires 5075**
operators and 434 time steps.

So far, we have controlled where airplanes fly, when people board an airplane, and when they debark. There are no rules governing refueling, and a quick look at a plan for one of the larger problem instances reveals that whenever an aircraft has nothing else to do, it will refuel. This seems a little bit wasteful, but we are satisfied **with adding a rule stating that** airplanes must only refuel when their tanks are empty. This rule is not perfect, since an airplane may miss an opportunity to "pre-emptively" refuel **and it can still refuel one fuel** level even if it is not going to fly, but it does provide a significant improvement, bringing the number of operators down to 4234. The number of time steps **is still 434.**
A few minor adjustments were made to these rules before they were used in the competition. These adjustments include a modification to only-board-when-necessary **to ensure**
that a person who must travel from city to city2 **will choose a plane that already needs**
to visit both city and city2**, if this is possible, since this is less likely to increase the total**
number of flights.

One final change is prompted by the fact that the intended differences in timing between fly and zoom **cannot be modelled correctly in the STRIPS version of the domain. Since**
all operators must take the same amount of time, the only difference between these two operators is that zoom **uses twice as much fuel. Although it would have been possible** to add a control rule ensuring that zoom **was not used, it was easier to simply remove the** zoom operator from the domain definition.

## 5.2.2 Zenotravel: Simpletime

The SimpleTime version of ZenoTravel is quite similar to the **STRIPS version, the only** difference being that actions may have non-unit duration and **that certain preconditions** must hold throughout the execution of an action. The TALplanner operator definitions are changed accordingly. For example, the board and fly **operators can be changed as follows:**
\#operator **board**(person, aircraft, city) :at t
:precond [t] at(person, city) ∧ at(aircraft, city) :prevail **[t+1, t+20]** at(aircraft, city)
:duration 20
:effects [t+1] at(person, city) := false, **[t+20]** in(person, aircraft) := true