

![0_image_0.png](0_image_0.png)

\#operator fly(aircraft, city1, city2, flevel1, flevel2) :at t
:precond [t] at(aircraft, city1) ∧ fuel-level(aircraft, flevel1) ∧ next(flevel2, flevel1)
:duration 180
:effects [t+1] at(aircraft, city1) := false, [t+1] fuel-level(aircraft, flevel1) := false,
[t+180] at(aircraft, city2) := true, **[t+180]** fuel-level(aircraft, flevel2) := true If we run the planner on a set of SimpleTime problem instances, we get almost immediate results: The planner claims that there is no plan for any of the instances. The reason for this is, of course, that the control rules must be satisfied in **any valid plan, and those rules**
were designed with the underlying assumption that actions had unit duration. For example, consider planes-always-fly-to-goal**, which states that if a plane leaves a city at time t, it should**
be at a meaningful destination at t+1. When the fly **action is invoked the plane must be**
at some city city1, but beginning at the next time step there will be an interval **where the** aircraft is not present in any city at all, until it finally arrives in city2 **180 time steps later.**
In other words, planes-always-fly-to-goal **now ensures that the fly operator cannot be used**
at all, which is not quite what was originally intended.

One way of solving this problem would be to alter planes-always-fly-to-goal **to say that if**
a plane leaves a city at time t, it should be at a meaningful destination at t+180. Unfortunately, the duration of the flight would then be encoded directly in the control rule instead of only in the operator, and so it would not work in the Timed version, where operators have variable durations - in fact, it would not even work in SimpleTime, because the zoom operator must also be taken into account.

Instead, the domain model is augmented with a new fluent flying-to(aircraft, city) **which**
keeps track of whether a plane is flying, and if so, what its destination is. To ensure that this fluent is kept up-to-date, the following is added to the effects of the fly and zoom **operators:**
[t+1] flying-to(aircraft, city2) := true, [t+180] flying-to(aircraft, city2) := false // **for fly**
[t+1] flying-to(aircraft, city2) := true, [t+100] flying-to(aircraft, city2) := false // **for zoom**
The planes-always-fly-to-goal **rule above can now be changed as follows, stating that if an**
aircraft ceases to be at city**, then it must be flying to a reasonable destination:**

#control :name "**planes-always-fly-to-goal**" [t] at(aircraft, city) ∧ [t+1] ¬at(aircraft, city) → ∃city2 [ [t+1] **flying-to**(aircraft, city2) ∧ . . . ]
The same problem arises for boarding, and a new fluent boarding(person, aircraft) **is added**
and used whenever necessary. Given these changes, the following are the first steps of the