Although forward-chaining planners may sometimes suffer from a lack of goal-directedness when compared to other types of planners, the use of explicitly represented domain-dependent knowledge is one way of compensating for this deficiency. More significantly, a forward chaining planner always has a complete description of the past and current states, which facilitates the use of complex operator types with complex preconditions and conditional effects. This expressivity was useful when TALplanner participated in the third International Planning Competition (IPC-20021**), which had a clear emphasis on increasing the**
complexity of the problem domains used as benchmark tests and the expressivity required to represent these domains in a planning system. In fact, TALplanner already had support for several new features that had not been present in IPC-2000 2**, such as the use of numeric**
state variables and temporally extended actions with variable duration.

Nevertheless, several extensions and changes had to be implemented before and during the competition in order to accommodate the semantics of PDDL2.1, the new version of PDDL (Planning Domain Definition Language, Fox & Long, 2003) **which was used to specify**
problem domains and problem instances. These extensions and changes are the first topic of this article, and after an introduction to TALplanner (Sections 2 and 3), the extensions will be discussed in Section 4. The second topic is that of describing the domain-dependent control rules that were used for the six benchmark problem domains in the hand-tailored track of the competition, and more importantly, the process **of generating those rules and** the reasoning behind them (Section 5). We will also describe **some new changes that have**
been made to TALplanner after the competition (Section 6). Finally, we will conclude with a discussion of the positive and negative sides of using **search control knowledge in**
TALplanner together with some pointers towards possible future research topics.

Please see Long and Fox (2003) for further information about **the basic setup of the**
competition, detailed descriptions of the planning domains being used, and timing and plan quality results.

## 2. Representation: Using Tal In Talplanner

The semantics of TALplanner is based on an extended version of TAL-C (Karlsson &
Gustafsson, 1999; Doherty, Gustafsson, Karlsson, & Kvarnstr¨om, 1998), a member of the TAL (Temporal Action Logics) family of narrative-based non-monotonic linear discrete metric time logics for reasoning about action and change. TAL-C has been developed for modeling domains that may include the use of incomplete information, delayed effects of actions, finite or infinite chains of indirect effects, interacting concurrent actions, and independent processes not directly triggered by action invocations. Consequently, it was seen as an ideal choice not only for the initial version of TALplanner but also for most extensions that could conceivably be implemented in the foreseeable future.

A TAL narrative consists of a set of labeled statements in a high-level macro language L**(ND), where the basic language has a number of statement classes for observations of fluent**
values (labeled obs**), action descriptions (**acs**), action occurrences (**occ**), domain constraints**
(dom**), and dependency constraints modeling causal relations and indirect effects (**dep). The formal semantics of L**(ND) is defined by a translation into an order-sorted first-order** base language L(FL) and by a circumscription policy providing a solution to **the frame and** ramification problems (Doherty, 1994; Gustafsson & Doherty, 1996; Doherty et al., 1998).