plan generated by TALplanner for the problem instance in Figure 4, shown in the IPC-2002 timed result format where the timepoint at which an action is **invoked is followed by the**
action instance and the duration of the action:
0: (board person1 plane1 city0) [20]
20: (fly plane1 city0 city1 fl4 fl3) [180] 20: (zoom plane1 city0 city1 fl4 fl3 fl2) [100] Intuitively, flying and zooming plane1 **at the same time should be impossible, but we have** forgotten to specify this to the planner. Both actions have their preconditions satisfied at time 20, there are no prevail conditions, and the effects of the actions do not contradict each other since they take place at different timepoints: fly **ends at time 200, while** zoom ends at time 120.

There are several ways of specifying that fly and zoom **are mutually exclusive. For**
example, it would be possible to introduce an interval effect **stating that** flying-to(aircraft, city2) must hold throughout the inner execution intervals of these **actions, and become false**
at the end of each action:
[t+1,t+179] flying-to(aircraft, city2) := true, [t+180] flying-to(aircraft, city2) := false // **for fly** [t+1,t+ 99] flying-to(aircraft, city2) := true, [t+100] flying-to(aircraft, city2) := false // **zoom**
It would also be possible to use a semaphore resource: An aircraft-specific resource with an initial value of 1, which can be borrowed exclusively by the fly and zoom **actions. When** one of these solutions is used, TALplanner finally rewards us **with a short and correct plan:** 0: (board person1 plane1 city0) [20] 20: (fly plane1 city0 city1 fl4 fl3) [180] 200: (board person3 plane1 city1) [20]
200: (debark person1 plane1 city1) [30] 230: (fly plane1 city1 city0 fl3 fl2) [180]
410: (debark person3 plane1 city0) [30]
;; Plan length 6, maxtime 440 Can it be improved? Remember that the STRIPS version never made use of the zoom operator. But in the SimpleTime version, flying takes 180 time steps and uses one unit of fuel, zooming takes 100 time steps and uses two units of fuel, and refueling one unit takes 73 time steps. 180 + 73 is more than 100 + 2 · **73 and therefore we have the opposite** situation: zoom is always better than fly. Commenting out the **unwanted fly operator yields** the following plan: 0: (board person1 plane1 city0) [20] 20: (zoom plane1 city0 city1 fl4 fl3 fl2) [100] 120: (board person3 plane1 city1) [20]
120: (debark person1 plane1 city1) [30]
150: (zoom plane1 city1 city0 fl2 fl1 fl0) [100] 250: (debark person3 plane1 city0) [30] ;; Plan length 6, maxtime 280